/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.deployment.engine;

import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.debezium.deployment.dotnames.DebeziumDotNames;
import io.quarkus.debezium.deployment.engine.GeneratedClassMetaData;
import io.quarkus.debezium.deployment.engine.GizmoBasedCapturingInvokerGenerator;
import io.quarkus.debezium.engine.capture.CapturingObjectInvoker;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.runtime.util.HashUtil;
import java.util.Optional;
import java.util.UUID;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class CapturingObjectInvokerGenerator
implements GizmoBasedCapturingInvokerGenerator {
    private final ClassOutput output;

    public CapturingObjectInvokerGenerator(ClassOutput classOutput) {
        this.output = classOutput;
    }

    @Override
    public boolean isCompatible(Type type) {
        return !(type instanceof ParameterizedType);
    }

    @Override
    public GeneratedClassMetaData generate(MethodInfo methodInfo, BeanInfo beanInfo) {
        String name = this.generateClassName(beanInfo, methodInfo);
        try (ClassCreator invoker = ClassCreator.builder().classOutput(this.output).className(name).interfaces(new Class[]{CapturingObjectInvoker.class}).build();){
            FieldDescriptor beanInstanceField = this.constructorWithObjectField(methodInfo, invoker, "beanInstance");
            this.createCaptureMethod(methodInfo, invoker, beanInstanceField, Object.class);
            try (MethodCreator destination = invoker.getMethodCreator("destination", String.class, new Class[0]);){
                Optional.ofNullable(methodInfo.annotation(DebeziumDotNames.CAPTURING).value("destination")).map(AnnotationValue::asString).ifPresentOrElse(s -> {
                    if (s.isEmpty()) {
                        throw new IllegalArgumentException("empty destination are not allowed for @Capturing annotation  " + String.valueOf(methodInfo.declaringClass()));
                    }
                    destination.returnValue(destination.load(s));
                }, () -> {
                    throw new RuntimeException("trying to capture events without defining a destination for class " + String.valueOf(methodInfo.declaringClass()));
                });
            }
            this.createEngineMethod(methodInfo, invoker);
            GeneratedClassMetaData generatedClassMetaData = new GeneratedClassMetaData(UUID.randomUUID(), name.replace('/', '.'), beanInfo, CapturingObjectInvoker.class);
            return generatedClassMetaData;
        }
    }

    private String generateClassName(BeanInfo bean, MethodInfo methodInfo) {
        return DotNames.internalPackageNameWithTrailingSlash((DotName)bean.getImplClazz().name()) + DotNames.simpleName((DotName)bean.getImplClazz().name()) + "_DebeziumInvoker_" + methodInfo.name() + "_" + HashUtil.sha1((String)(methodInfo.name() + "_" + methodInfo.returnType().name().toString()));
    }
}

