/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.deployment.engine;

import io.quarkus.debezium.deployment.dotnames.DebeziumDotNames;
import io.quarkus.debezium.deployment.engine.CapturingInvokerGenerator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.util.Optional;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.MethodInfo;

interface GizmoBasedCapturingInvokerGenerator
extends CapturingInvokerGenerator {
    default public FieldDescriptor constructorWithObjectField(MethodInfo methodInfo, ClassCreator invoker, String fieldName) {
        FieldDescriptor beanInstanceField = ((FieldCreator)invoker.getFieldCreator(fieldName, methodInfo.declaringClass().name().toString()).setModifiers(2)).getFieldDescriptor();
        try (MethodCreator constructor = invoker.getMethodCreator("<init>", Void.TYPE, new Class[]{Object.class});){
            constructor.setModifiers(1);
            constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
            ResultHandle constructorThis = constructor.getThis();
            ResultHandle beanInstance = constructor.getMethodParam(0);
            constructor.writeInstanceField(beanInstanceField, constructorThis, beanInstance);
            constructor.returnValue(null);
        }
        return beanInstanceField;
    }

    default public void createCaptureMethod(MethodInfo methodInfo, ClassCreator invoker, FieldDescriptor beanInstanceField, Class<?> clazz) {
        try (MethodCreator capture = invoker.getMethodCreator("capture", Void.TYPE, new Class[]{clazz});){
            ResultHandle captureThis = capture.getThis();
            ResultHandle delegate = capture.readInstanceField(beanInstanceField, captureThis);
            ResultHandle event = capture.getMethodParam(0);
            MethodDescriptor methodDescriptor = MethodDescriptor.ofMethod((String)methodInfo.declaringClass().toString(), (String)methodInfo.name(), (String)"V", (String[])new String[]{methodInfo.parameterType(0).name().toString()});
            capture.invokeVirtualMethod(methodDescriptor, delegate, new ResultHandle[]{event});
            capture.returnVoid();
        }
    }

    default public void createEngineMethod(MethodInfo methodInfo, ClassCreator invoker) {
        try (MethodCreator engine = invoker.getMethodCreator("engine", String.class, new Class[0]);){
            Optional.ofNullable(methodInfo.annotation(DebeziumDotNames.CAPTURING).value("engine")).map(AnnotationValue::asString).ifPresentOrElse(s -> {
                if (s.isEmpty()) {
                    throw new IllegalArgumentException("empty engine is not allowed for @Capturing annotation  " + String.valueOf(methodInfo.declaringClass()));
                }
                engine.returnValue(engine.load(s));
            }, () -> engine.returnValue(engine.load("default")));
        }
    }
}

