/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.deployment.engine;

import io.debezium.runtime.CapturingEvent;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.debezium.deployment.dotnames.DebeziumDotNames;
import io.quarkus.debezium.deployment.engine.CapturingInvokerGenerator;
import io.quarkus.debezium.deployment.engine.GeneratedClassMetaData;
import io.quarkus.debezium.engine.capture.CapturingEventInvoker;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import java.util.Optional;
import java.util.UUID;
import org.apache.kafka.connect.source.SourceRecord;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class CapturingEventGenerator
implements CapturingInvokerGenerator {
    private final ClassOutput output;

    public CapturingEventGenerator(ClassOutput output) {
        this.output = output;
    }

    @Override
    public boolean isCompatible(Type type) {
        return ParameterizedType.create(CapturingEvent.class, (Type[])new Type[]{Type.create(SourceRecord.class)}).equals((Object)type);
    }

    @Override
    public GeneratedClassMetaData generate(MethodInfo methodInfo, BeanInfo beanInfo) {
        String name = this.generateClassName(beanInfo, methodInfo);
        try (ClassCreator invoker = ClassCreator.builder().classOutput(this.output).className(name).interfaces(new Class[]{CapturingEventInvoker.class}).build();){
            FieldDescriptor beanInstanceField = ((FieldCreator)invoker.getFieldCreator("beanInstance", methodInfo.declaringClass().name().toString()).setModifiers(2)).getFieldDescriptor();
            try (MethodCreator constructor = invoker.getMethodCreator("<init>", Void.TYPE, new Class[]{Object.class});){
                constructor.setModifiers(1);
                constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
                ResultHandle constructorThis = constructor.getThis();
                ResultHandle beanInstance = constructor.getMethodParam(0);
                constructor.writeInstanceField(beanInstanceField, constructorThis, beanInstance);
                constructor.returnValue(null);
            }
            try (MethodCreator capture = invoker.getMethodCreator("capture", Void.TYPE, new Class[]{CapturingEvent.class});){
                ResultHandle captureThis = capture.getThis();
                ResultHandle delegate = capture.readInstanceField(beanInstanceField, captureThis);
                ResultHandle event = capture.getMethodParam(0);
                MethodDescriptor methodDescriptor = MethodDescriptor.ofMethod((String)methodInfo.declaringClass().toString(), (String)methodInfo.name(), (String)"V", (String[])new String[]{methodInfo.parameterType(0).name().toString()});
                capture.invokeVirtualMethod(methodDescriptor, delegate, new ResultHandle[]{event});
                capture.returnVoid();
            }
            try (MethodCreator destination = invoker.getMethodCreator("destination", String.class, new Class[0]);){
                Optional.ofNullable(methodInfo.annotation(DebeziumDotNames.CAPTURING).value("destination")).map(AnnotationValue::asString).ifPresentOrElse(s -> {
                    if (s.isEmpty()) {
                        throw new IllegalArgumentException("empty destination are not allowed for @Capturing annotation  " + String.valueOf(methodInfo.declaringClass()));
                    }
                    destination.returnValue(destination.load(s));
                }, () -> destination.returnValue(destination.load("*")));
            }
            GeneratedClassMetaData generatedClassMetaData = new GeneratedClassMetaData(UUID.randomUUID(), name.replace('/', '.'), beanInfo, CapturingEventInvoker.class);
            return generatedClassMetaData;
        }
    }

    private String generateClassName(BeanInfo bean, MethodInfo methodInfo) {
        return DotNames.internalPackageNameWithTrailingSlash((DotName)bean.getImplClazz().name()) + DotNames.simpleName((DotName)bean.getImplClazz().name()) + "_DebeziumInvoker_" + methodInfo.name() + "_" + HashUtil.sha1((String)(methodInfo.name() + "_" + methodInfo.returnType().name().toString()));
    }
}

