/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers.util.dns;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeDns {
    public static final Logger LOGGER = LoggerFactory.getLogger(FakeDns.class);
    private static final FakeDns instance = new FakeDns();
    private final Map<String, InetAddress> registry;
    private final AtomicBoolean enabled = new AtomicBoolean(false);

    private FakeDns() {
        this.registry = new ConcurrentHashMap<String, InetAddress>();
    }

    public static FakeDns getInstance() {
        return instance;
    }

    public void addResolution(String hostname, InetAddress ip) {
        this.registry.put(hostname, ip);
        LOGGER.info("Added dns resolution: {} -> {}", (Object)hostname, (Object)ip);
    }

    public void removeResolution(String hostname, InetAddress ip) {
        this.registry.remove(hostname, ip);
        LOGGER.info("Removed dns resolution: {} -> {}", (Object)hostname, (Object)ip);
    }

    public Optional<InetAddress> resolve(String hostname) {
        return this.isEnabled() ? this.resolveInternal(hostname) : Optional.empty();
    }

    public Optional<String> resolve(byte[] address) {
        return this.isEnabled() ? this.resolveInternal(address) : Optional.empty();
    }

    private Optional<InetAddress> resolveInternal(String hostname) {
        LOGGER.info("Performing Forward Lookup for HOST : {}", (Object)hostname);
        return Optional.of(this.registry.get(hostname));
    }

    private Optional<String> resolveInternal(byte[] address) {
        LOGGER.info("Performing Reverse Lookup for Address : {}", (Object)Arrays.toString(address));
        return this.registry.keySet().stream().filter(host -> Arrays.equals(this.registry.get(host).getAddress(), address)).findFirst();
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public FakeDns enable() {
        this.enabled.set(true);
        return this;
    }

    public FakeDns disable() {
        this.enabled.set(false);
        return this;
    }
}

