/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.SyncDockerCmd;
import com.github.dockerjava.api.model.ContainerNetwork;
import io.debezium.testing.testcontainers.util.DockerUtils;
import io.debezium.testing.testcontainers.util.PortResolver;
import io.debezium.testing.testcontainers.util.RandomPortResolver;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class MongoDbContainer
extends GenericContainer<MongoDbContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbContainer.class);
    public static final String IMAGE_VERSION = System.getProperty("version.mongo.server", "6.0");
    private static final DockerImageName IMAGE_NAME = DockerImageName.parse((String)("mongo:" + IMAGE_VERSION));
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String CONTAINER_KEYFILE_PATH = "/data/replica.key";
    private final String name;
    private final int port;
    private final String replicaSet;
    private final PortResolver portResolver;
    private final String process;
    private final String typeFlag;
    private final String configAddress;
    private String username;
    private String password;
    private String authSource;
    private boolean authUserEnabled = false;
    private final boolean authEnabled;

    public static Builder node() {
        return new Builder();
    }

    public static Builder router(String configAddress) {
        return new Builder().router(configAddress);
    }

    public static Builder configServerNode() {
        return new Builder().configServer();
    }

    public static Builder shardServerNode() {
        return new Builder().shardServer();
    }

    private MongoDbContainer(Builder builder) {
        super(builder.imageName);
        this.process = builder.process;
        this.typeFlag = builder.typeFlag;
        this.name = builder.name;
        this.replicaSet = builder.replicaSet;
        this.portResolver = builder.portResolver;
        this.authEnabled = builder.authEnabled;
        this.configAddress = builder.configAddress;
        if (DockerUtils.isContainerVM()) {
            this.port = this.portResolver.resolveFreePort();
            this.addFixedExposedPort(this.port, this.port);
        } else {
            this.port = builder.port;
        }
        DockerUtils.logContainerVMBanner(LOGGER, List.of(this.name), builder.skipDockerDesktopLogWarning);
        this.withNetwork(builder.network);
        this.withNetworkAliases(new String[]{this.name});
    }

    protected void configure() {
        this.withCreateContainerCmdModifier(createCommand -> createCommand.withEntrypoint(new String[]{"sh"}));
        String command = "docker-entrypoint.sh " + this.process + " " + (this.typeFlag == null ? "" : this.typeFlag) + " " + (String)(this.replicaSet == null ? "" : "--replSet " + this.replicaSet) + " " + (String)(this.configAddress == null ? "" : "--configdb " + this.configAddress) + " --port " + this.port + " --bind_ip localhost," + this.name;
        if (this.authEnabled) {
            String keyFileCommand = "echo 'secret' > /data/replica.key && chown 999:999 /data/replica.key && chmod 0600 /data/replica.key";
            command = keyFileCommand + " && " + command + " --keyFile /data/replica.key";
        }
        LOGGER.info("command is: " + command);
        this.withCommand(new String[]{"-c", command});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)"(?i).*waiting for connections.*", (int)1));
    }

    public Address getClientAddress() {
        this.checkStarted();
        if (DockerUtils.isContainerVM()) {
            return this.getNamedAddress();
        }
        return new Address(this.getNetworkIp(), this.port);
    }

    public Address getNamedAddress() {
        return new Address(this.name, this.port);
    }

    public void initReplicaSet(boolean configServer, Address ... Addresses2) {
        LOGGER.info("[{}:{}] Initializing replica set...", (Object)this.replicaSet, (Object)this.name);
        this.eval("rs.initiate({_id:'" + this.replicaSet + "',configsvr:" + configServer + ",members:[" + IntStream.range(0, Addresses2.length).mapToObj(i -> "{_id:" + i + ",host:'" + String.valueOf(Addresses2[i]) + "'}").collect(Collectors.joining(",")) + "]})");
    }

    public Container.ExecResult execMongoScriptInContainer(MountableFile file, String containerPath) {
        try {
            this.copyFileToContainer(file, containerPath);
            return this.execMongoInContainer(containerPath);
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void stepDown() {
        LOGGER.info("[{}:{}] Stepping down...", (Object)this.replicaSet, (Object)this.name);
        this.eval("rs.stepDown()");
    }

    public void kill() {
        LOGGER.info("[{}:{}] Killing...", (Object)this.replicaSet, (Object)this.name);
        this.dockerCommand(client -> client.killContainerCmd(this.getContainerId()));
    }

    public void pause() {
        LOGGER.info("[{}:{}] Pausing...", (Object)this.replicaSet, (Object)this.name);
        this.dockerCommand(client -> client.pauseContainerCmd(this.getContainerId()));
    }

    public void unpause() {
        LOGGER.info("[{}:{}] Unpausing...", (Object)this.replicaSet, (Object)this.name);
        this.dockerCommand(client -> client.unpauseContainerCmd(this.getContainerId()));
    }

    private String getNetworkIp() {
        InspectContainerResponse info = this.getContainerInfo();
        return info.getNetworkSettings().getNetworks().values().stream().findFirst().map(ContainerNetwork::getIpAddress).orElseThrow();
    }

    private void dockerCommand(Function<DockerClient, SyncDockerCmd<?>> action) {
        action.apply(DockerClientFactory.instance().client()).exec();
    }

    public Container.ExecResult execMongoInContainer(String ... command) throws IOException, InterruptedException {
        this.checkStarted();
        String mongoCommand = Stream.concat(Stream.of(MongoDbContainer.isLegacy() ? "" : "mongosh", "mongo", "--quiet", "--host " + (this.authUserEnabled ? this.name : "localhost"), "--port " + this.port, this.authUserEnabled ? "--username " + this.username : "", this.authUserEnabled ? "--password " + this.password : "", this.authUserEnabled ? "--authenticationDatabase " + this.authSource : ""), Arrays.stream(command)).collect(Collectors.joining(" "));
        LOGGER.debug("Running command inside container: {}", (Object)mongoCommand);
        Container.ExecResult result = this.execInContainer(new String[]{"sh", "-c", mongoCommand});
        LOGGER.debug(result.getStdout());
        this.checkExitCode(result);
        return result;
    }

    public JsonNode eval(String command) {
        try {
            Container.ExecResult result = this.execMongoInContainer("--eval", "\"JSON.stringify(" + command + ")\"");
            String stdout = result.getStdout();
            JsonNode response = MongoDbContainer.parseResponse(stdout);
            LOGGER.info("{}:", (Object)response);
            return response;
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static JsonNode parseResponse(String stdout) {
        try {
            return OBJECT_MAPPER.readTree(stdout);
        }
        catch (IOException e) {
            LOGGER.warn("Could not parse the following text as JSON: {}", (Object)stdout, (Object)e);
            return OBJECT_MAPPER.createObjectNode();
        }
    }

    private void checkExitCode(Container.ExecResult result) {
        boolean ok;
        boolean bl = ok = result.getExitCode() == 0 || MongoDbContainer.isLegacy() && result.getExitCode() == 252;
        if (ok) {
            return;
        }
        String message = "An error occurred: " + result.getStderr();
        LOGGER.error(message);
        throw new IllegalStateException(message);
    }

    private void checkStarted() {
        if (this.getContainerId() == null) {
            throw new IllegalStateException("Cannot execute operation before calling `start`.");
        }
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        super.containerIsStarted(containerInfo);
        DockerUtils.addFakeDnsEntry(this.name);
    }

    public void createUser(String username, String password, String database, boolean setDefault, String ... rolePairs) {
        if (!this.authEnabled) {
            throw new IllegalStateException("MongoDB not started with authentication support");
        }
        if (rolePairs.length < 1) {
            throw new IllegalArgumentException("At least one role has to be specified");
        }
        String roles = Arrays.stream(rolePairs).map(this::mapPairToRole).collect(Collectors.joining(",", "[", "]"));
        this.eval("db.getSiblingDB('" + database + "').createUser({user: '" + username + "', pwd: '" + password + "', roles:" + roles + "})");
        if (setDefault) {
            this.username = username;
            this.password = password;
            this.authSource = database;
            this.authUserEnabled = true;
        }
    }

    private String mapPairToRole(String pair) {
        String[] parts = pair.split(Pattern.quote(":"), 2);
        if (parts.length == 1) {
            return "'" + parts[0] + "'";
        }
        return "{ role: '" + parts[0] + "', db: '" + parts[1] + "' }";
    }

    protected void containerIsStopped(InspectContainerResponse containerInfo) {
        super.containerIsStopped(containerInfo);
        DockerUtils.removeFakeDnsEntry(this.name);
        this.portResolver.releasePort(this.port);
    }

    private static boolean isLegacy() {
        int major = Integer.parseInt(IMAGE_VERSION.substring(0, 1));
        return major <= 4;
    }

    public static final class Builder {
        private DockerImageName imageName = IMAGE_NAME;
        private String name;
        private int port = 27017;
        private PortResolver portResolver = new RandomPortResolver();
        private String replicaSet;
        private Network network = Network.SHARED;
        private boolean skipDockerDesktopLogWarning = false;
        private boolean authEnabled = false;
        private String typeFlag = null;
        private String configAddress = null;
        private String process = "mongod";

        private Builder router(String configAddress) {
            this.process = "mongos";
            this.configAddress = configAddress;
            return this;
        }

        public Builder configServer() {
            this.typeFlag = "--configsvr";
            return this;
        }

        public Builder shardServer() {
            this.typeFlag = "--shardsvr";
            return this;
        }

        public Builder imageName(DockerImageName imageName) {
            if (imageName != null) {
                this.imageName = imageName;
            }
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder portResolver(PortResolver portResolver) {
            this.portResolver = portResolver;
            return this;
        }

        public Builder replicaSet(String replicaSet) {
            this.replicaSet = replicaSet;
            return this;
        }

        public Builder network(Network network) {
            this.network = network;
            return this;
        }

        public Builder skipDockerDesktopLogWarning(boolean skipDockerDesktopLogWarning) {
            this.skipDockerDesktopLogWarning = skipDockerDesktopLogWarning;
            return this;
        }

        public Builder authEnabled(boolean authEnabled) {
            this.authEnabled = authEnabled;
            return this;
        }

        public MongoDbContainer build() {
            return new MongoDbContainer(this);
        }
    }

    public static class Address {
        private final String host;
        private final int port;

        public Address(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            return this.host + ":" + this.port;
        }
    }
}

