/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers.testhelper;

import io.debezium.testing.testcontainers.Connector;
import io.debezium.testing.testcontainers.DebeziumContainer;
import io.debezium.testing.testcontainers.MongoDbReplicaSet;
import io.debezium.testing.testcontainers.OracleContainer;
import io.debezium.testing.testcontainers.util.MoreStartables;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.containers.MariaDBContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.startupcheck.MinimumDurationRunningStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public class TestInfrastructureHelper {
    public static final String KAFKA_HOSTNAME = "kafka-dbz";
    public static final int CI_CONTAINER_STARTUP_TIME = 90;
    private static final String DEBEZIUM_CONTAINER_IMAGE_VERSION_LATEST = "latest";
    private static final Logger LOGGER = LoggerFactory.getLogger(TestInfrastructureHelper.class);
    private static final Network NETWORK = Network.newNetwork();
    private static final Pattern VERSION_PATTERN = Pattern.compile("^[1-9]\\d*\\.\\d+");
    private static final GenericContainer<?> KAFKA_CONTAINER = new GenericContainer(DockerImageName.parse((String)"quay.io/debezium/kafka:latest").asCompatibleSubstituteFor("kafka")).withNetworkAliases(new String[]{"kafka-dbz"}).withNetwork(NETWORK).withEnv("KAFKA_CONTROLLER_QUORUM_VOTERS", "1@kafka-dbz:9093").withEnv("CLUSTER_ID", "5Yr1SIgYQz-b-dgRabWx4g").withEnv("NODE_ID", "1");
    private static DebeziumContainer DEBEZIUM_CONTAINER = null;
    private static final PostgreSQLContainer<?> POSTGRES_CONTAINER = (PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(DockerImageName.parse((String)"quay.io/debezium/example-postgres:latest").asCompatibleSubstituteFor("postgres")).withNetwork(NETWORK)).withNetworkAliases(new String[]{"postgres"});
    private static final MySQLContainer<?> MYSQL_CONTAINER = (MySQLContainer)((MySQLContainer)((MySQLContainer)new MySQLContainer(DockerImageName.parse((String)"quay.io/debezium/example-mysql:latest").asCompatibleSubstituteFor("mysql")).withNetwork(NETWORK)).withUsername("mysqluser").withPassword("mysqlpw").withEnv("MYSQL_ROOT_PASSWORD", "debezium")).withNetworkAliases(new String[]{"mysql"});
    private static final MariaDBContainer<?> MARIADB_CONTAINER = (MariaDBContainer)((MariaDBContainer)((MariaDBContainer)new MariaDBContainer(DockerImageName.parse((String)"quay.io/debezium/example-mariadb:latest").asCompatibleSubstituteFor("mariadb")).withNetwork(NETWORK)).withUsername("mariadbuser").withPassword("mariadbpw").withEnv("MARIADB_ROOT_PASSWORD", "debezium")).withNetworkAliases(new String[]{"mariadb"});
    private static final MongoDbReplicaSet MONGODB_REPLICA = MongoDbReplicaSet.replicaSet().name("rs0").memberCount(1).network(NETWORK).imageName(DockerImageName.parse((String)"mongo:5.0")).startupTimeout(Duration.ofSeconds(90L)).build();
    private static final MSSQLServerContainer<?> SQL_SERVER_CONTAINER = (MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)new MSSQLServerContainer(DockerImageName.parse((String)"mcr.microsoft.com/mssql/server:2019-latest")).withNetwork(NETWORK)).withNetworkAliases(new String[]{"sqlserver"})).withEnv("SA_PASSWORD", "Password!")).withEnv("MSSQL_PID", "Standard")).withEnv("MSSQL_AGENT_ENABLED", "true")).withPassword("Password!").withInitScript("initialize-sqlserver-database.sql")).acceptLicense().waitingFor(new LogMessageWaitStrategy().withRegEx(".*SQL Server is now ready for client connections\\..*\\s").withTimes(1).withStartupTimeout(Duration.of(270L, ChronoUnit.SECONDS)))).withStartupCheckStrategy((StartupCheckStrategy)new MinimumDurationRunningStartupCheckStrategy(Duration.ofSeconds(10L)))).withConnectTimeoutSeconds(300);
    private static final OracleContainer ORACLE_CONTAINER = (OracleContainer)((org.testcontainers.containers.OracleContainer)((org.testcontainers.containers.OracleContainer)new OracleContainer().withNetwork(NETWORK)).withNetworkAliases(new String[]{"oracledb"})).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));

    public static Network getNetwork() {
        return NETWORK;
    }

    private static Supplier<Stream<Startable>> getContainers(DATABASE database) {
        Object dbStartable = switch (database.ordinal()) {
            case 0 -> POSTGRES_CONTAINER;
            case 1 -> MYSQL_CONTAINER;
            case 3 -> MONGODB_REPLICA;
            case 2 -> SQL_SERVER_CONTAINER;
            case 4 -> ORACLE_CONTAINER;
            case 5 -> MARIADB_CONTAINER;
            default -> null;
        };
        if (null != dbStartable) {
            return () -> Stream.of(new Startable[]{KAFKA_CONTAINER, dbStartable, DEBEZIUM_CONTAINER});
        }
        if (DATABASE.DEBEZIUM_ONLY.equals((Object)database)) {
            return () -> Stream.of(DEBEZIUM_CONTAINER);
        }
        return () -> Stream.of(new Startable[]{KAFKA_CONTAINER, DEBEZIUM_CONTAINER});
    }

    public static void stopContainers() {
        Stream<Startable> containers = Stream.of(new Startable[]{DEBEZIUM_CONTAINER, ORACLE_CONTAINER, SQL_SERVER_CONTAINER, MONGODB_REPLICA, MYSQL_CONTAINER, POSTGRES_CONTAINER, MARIADB_CONTAINER, KAFKA_CONTAINER});
        MoreStartables.deepStopSync(containers);
        DEBEZIUM_CONTAINER = null;
    }

    public static void startContainers(DATABASE database) {
        Supplier<Stream<Startable>> containers = TestInfrastructureHelper.getContainers(database);
        if ("true".equals(System.getenv("CI"))) {
            containers.get().forEach(container -> {
                if (container instanceof GenericContainer && !(container instanceof OracleContainer)) {
                    ((GenericContainer)container).withStartupTimeout(Duration.ofSeconds(90L));
                }
            });
        }
        MoreStartables.deepStartSync(containers.get());
    }

    public static void setupDebeziumContainer(String connectorVersion, String restExtensionClassses) {
        TestInfrastructureHelper.setupDebeziumContainer(connectorVersion, restExtensionClassses, DEBEZIUM_CONTAINER_IMAGE_VERSION_LATEST);
    }

    private static void waitForDebeziumContainerIsStopped() {
        Awaitility.await().atMost((long)DebeziumContainer.waitTimeForRecords() * 5L, TimeUnit.SECONDS).until(() -> !TestInfrastructureHelper.getDebeziumContainer().isRunning());
    }

    public static void setupDebeziumContainer(String connectorVersion, String restExtensionClasses, String debeziumContainerImageVersion) {
        if (null != DEBEZIUM_CONTAINER && DEBEZIUM_CONTAINER.isRunning()) {
            DEBEZIUM_CONTAINER.stop();
            TestInfrastructureHelper.waitForDebeziumContainerIsStopped();
        }
        String registry = debeziumContainerImageVersion.startsWith("1.2") ? "" : "quay.io/";
        String debeziumVersion = debeziumContainerImageVersion.startsWith("1.2") ? "1.2.5.Final" : connectorVersion;
        String baseImageName = registry + "debezium/connect-base:" + debeziumContainerImageVersion;
        DEBEZIUM_CONTAINER = (DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)new DebeziumContainer((Future<String>)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile("debezium/connect-rest-test:" + debeziumVersion).withFileFromPath(".", Paths.get(System.getProperty("project.build.directory"), new String[0]))).withFileFromPath("Dockerfile", Paths.get(System.getProperty("project.basedir") + "/src/test/resources/Dockerfile.rest.test", new String[0]))).withBuildArg("BASE_IMAGE", baseImageName).withBuildArg("DEBEZIUM_VERSION", debeziumVersion)).withEnv("ENABLE_DEBEZIUM_SCRIPTING", "true")).withNetwork(NETWORK)).withKafka(KAFKA_CONTAINER.getNetwork(), "kafka-dbz:9092").withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER))).enableJMX().dependsOn(new Startable[]{KAFKA_CONTAINER});
        if (null != restExtensionClasses && !restExtensionClasses.isEmpty()) {
            DEBEZIUM_CONTAINER.withEnv("CONNECT_REST_EXTENSION_CLASSES", restExtensionClasses);
        }
    }

    public static void defaultDebeziumContainer(String debeziumContainerImageVersion) {
        if (null != DEBEZIUM_CONTAINER && DEBEZIUM_CONTAINER.isRunning()) {
            DEBEZIUM_CONTAINER.stop();
            TestInfrastructureHelper.waitForDebeziumContainerIsStopped();
        }
        if (null == debeziumContainerImageVersion) {
            debeziumContainerImageVersion = DEBEZIUM_CONTAINER_IMAGE_VERSION_LATEST;
        } else {
            Matcher matcher = VERSION_PATTERN.matcher(debeziumContainerImageVersion);
            if (matcher.find()) {
                debeziumContainerImageVersion = matcher.toMatchResult().group();
            } else {
                throw new RuntimeException("Cannot parse version: " + debeziumContainerImageVersion);
            }
        }
        String registry = debeziumContainerImageVersion.startsWith("1.2") ? "" : "quay.io/";
        String imageName = registry + "debezium/connect:" + debeziumContainerImageVersion;
        DEBEZIUM_CONTAINER = (DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)new DebeziumContainer(DockerImageName.parse((String)imageName)).withEnv("ENABLE_DEBEZIUM_SCRIPTING", "true")).withNetwork(NETWORK)).withKafka(KAFKA_CONTAINER.getNetwork(), "kafka-dbz:9092").withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER))).enableJMX().dependsOn(new Startable[]{KAFKA_CONTAINER});
    }

    public static void defaultDebeziumContainer() {
        TestInfrastructureHelper.defaultDebeziumContainer(null);
    }

    public static GenericContainer<?> getKafkaContainer() {
        return KAFKA_CONTAINER;
    }

    public static DebeziumContainer getDebeziumContainer() {
        return DEBEZIUM_CONTAINER;
    }

    public static PostgreSQLContainer<?> getPostgresContainer() {
        return POSTGRES_CONTAINER;
    }

    public static MySQLContainer<?> getMySqlContainer() {
        return MYSQL_CONTAINER;
    }

    public static MongoDbReplicaSet getMongoDbContainer() {
        return MONGODB_REPLICA;
    }

    public static MSSQLServerContainer<?> getSqlServerContainer() {
        return SQL_SERVER_CONTAINER;
    }

    public static OracleContainer getOracleContainer() {
        return ORACLE_CONTAINER;
    }

    public static MariaDBContainer getMariaDbContainer() {
        return MARIADB_CONTAINER;
    }

    public static void waitForConnectorTaskStatus(String connectorName, int taskNumber, Connector.State state) {
        Awaitility.await().atMost(120L, TimeUnit.SECONDS).until(() -> TestInfrastructureHelper.getDebeziumContainer().getConnectorTaskState(connectorName, taskNumber) == state);
    }

    public static enum DATABASE {
        POSTGRES,
        MYSQL,
        SQLSERVER,
        MONGODB,
        ORACLE,
        MARIADB,
        NONE,
        DEBEZIUM_ONLY;

    }
}

