/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers.testhelper;

import io.debezium.testing.testcontainers.Connector;
import io.debezium.testing.testcontainers.DebeziumContainer;
import io.debezium.testing.testcontainers.MongoDbReplicaSet;
import io.debezium.testing.testcontainers.OracleContainer;
import io.debezium.testing.testcontainers.util.MoreStartables;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.containers.MariaDBContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.startupcheck.MinimumDurationRunningStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public class RestExtensionTestInfrastructure {
    public static final String KAFKA_HOSTNAME = "kafka-dbz-ui";
    public static final int CI_CONTAINER_STARTUP_TIME = 90;
    private static final String DEBEZIUM_CONTAINER_IMAGE_VERSION_LATEST = "latest";
    private static final Logger LOGGER = LoggerFactory.getLogger(RestExtensionTestInfrastructure.class);
    private static final Network NETWORK = Network.newNetwork();
    private static final GenericContainer<?> KAFKA_CONTAINER = new GenericContainer(DockerImageName.parse((String)"quay.io/debezium/kafka:latest").asCompatibleSubstituteFor("kafka")).withNetworkAliases(new String[]{"kafka-dbz-ui"}).withNetwork(NETWORK).withEnv("KAFKA_CONTROLLER_QUORUM_VOTERS", "1@kafka-dbz-ui:9093").withEnv("CLUSTER_ID", "5Yr1SIgYQz-b-dgRabWx4g").withEnv("NODE_ID", "1");
    private static DebeziumContainer DEBEZIUM_CONTAINER = null;
    private static final PostgreSQLContainer<?> POSTGRES_CONTAINER = (PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(DockerImageName.parse((String)"quay.io/debezium/example-postgres:latest").asCompatibleSubstituteFor("postgres")).withNetwork(NETWORK)).withNetworkAliases(new String[]{"postgres"});
    private static final MySQLContainer<?> MYSQL_CONTAINER = (MySQLContainer)((MySQLContainer)((MySQLContainer)new MySQLContainer(DockerImageName.parse((String)"quay.io/debezium/example-mysql:latest").asCompatibleSubstituteFor("mysql")).withNetwork(NETWORK)).withUsername("mysqluser").withPassword("mysqlpw").withEnv("MYSQL_ROOT_PASSWORD", "debezium")).withNetworkAliases(new String[]{"mysql"});
    private static final MariaDBContainer<?> MARIADB_CONTAINER = (MariaDBContainer)((MariaDBContainer)((MariaDBContainer)new MariaDBContainer(DockerImageName.parse((String)"quay.io/debezium/example-mariadb:latest").asCompatibleSubstituteFor("mariadb")).withNetwork(NETWORK)).withUsername("mariadbuser").withPassword("mariadbpw").withEnv("MARIADB_ROOT_PASSWORD", "debezium")).withNetworkAliases(new String[]{"mariadb"});
    private static final MongoDbReplicaSet MONGODB_REPLICA = MongoDbReplicaSet.replicaSet().name("rs0").memberCount(1).network(NETWORK).imageName(DockerImageName.parse((String)"mongo:5.0")).startupTimeout(Duration.ofSeconds(90L)).build();
    private static final MSSQLServerContainer<?> SQL_SERVER_CONTAINER = (MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)((MSSQLServerContainer)new MSSQLServerContainer(DockerImageName.parse((String)"mcr.microsoft.com/mssql/server:2019-latest")).withNetwork(NETWORK)).withNetworkAliases(new String[]{"sqlserver"})).withEnv("SA_PASSWORD", "Password!")).withEnv("MSSQL_PID", "Standard")).withEnv("MSSQL_AGENT_ENABLED", "true")).withPassword("Password!").withInitScript("initialize-sqlserver-database.sql")).acceptLicense().waitingFor(new LogMessageWaitStrategy().withRegEx(".*SQL Server is now ready for client connections\\..*\\s").withTimes(1).withStartupTimeout(Duration.of(270L, ChronoUnit.SECONDS)))).withStartupCheckStrategy((StartupCheckStrategy)new MinimumDurationRunningStartupCheckStrategy(Duration.ofSeconds(10L)))).withConnectTimeoutSeconds(300);
    private static final OracleContainer ORACLE_CONTAINER = (OracleContainer)((org.testcontainers.containers.OracleContainer)((org.testcontainers.containers.OracleContainer)new OracleContainer().withNetwork(NETWORK)).withNetworkAliases(new String[]{"oracledb"})).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));

    private static Supplier<Stream<Startable>> getContainers(DATABASE database) {
        Object dbStartable;
        switch (database.ordinal()) {
            case 0: {
                dbStartable = POSTGRES_CONTAINER;
                break;
            }
            case 1: {
                dbStartable = MYSQL_CONTAINER;
                break;
            }
            case 3: {
                dbStartable = MONGODB_REPLICA;
                break;
            }
            case 2: {
                dbStartable = SQL_SERVER_CONTAINER;
                break;
            }
            case 4: {
                dbStartable = ORACLE_CONTAINER;
                break;
            }
            case 5: {
                dbStartable = MARIADB_CONTAINER;
                break;
            }
            default: {
                dbStartable = null;
            }
        }
        if (null != dbStartable) {
            return () -> Stream.of(new Startable[]{KAFKA_CONTAINER, dbStartable, DEBEZIUM_CONTAINER});
        }
        return () -> Stream.of(new Startable[]{KAFKA_CONTAINER, DEBEZIUM_CONTAINER});
    }

    public static void stopContainers() {
        Stream<Startable> containers = Stream.of(new Startable[]{DEBEZIUM_CONTAINER, ORACLE_CONTAINER, SQL_SERVER_CONTAINER, MONGODB_REPLICA, MYSQL_CONTAINER, POSTGRES_CONTAINER, MARIADB_CONTAINER, KAFKA_CONTAINER});
        MoreStartables.deepStopSync(containers);
        DEBEZIUM_CONTAINER = null;
    }

    public static void startContainers(DATABASE database) {
        Supplier<Stream<Startable>> containers = RestExtensionTestInfrastructure.getContainers(database);
        if ("true".equals(System.getenv("CI"))) {
            containers.get().forEach(container -> {
                if (container instanceof GenericContainer && !(container instanceof OracleContainer)) {
                    ((GenericContainer)container).withStartupTimeout(Duration.ofSeconds(90L));
                }
            });
        }
        MoreStartables.deepStartSync(containers.get());
    }

    public static void setupDebeziumContainer(String connectorVersion, String restExtensionClassses) {
        RestExtensionTestInfrastructure.setupDebeziumContainer(connectorVersion, restExtensionClassses, DEBEZIUM_CONTAINER_IMAGE_VERSION_LATEST);
    }

    public static void setupDebeziumContainer(String connectorVersion, String restExtensionClasses, String debeziumContainerImageVersion) {
        if (null != DEBEZIUM_CONTAINER && DEBEZIUM_CONTAINER.isRunning()) {
            DEBEZIUM_CONTAINER.stop();
        }
        String registry = debeziumContainerImageVersion.startsWith("1.2") ? "" : "quay.io/";
        String debeziumVersion = debeziumContainerImageVersion.startsWith("1.2") ? "1.2.5.Final" : connectorVersion;
        String baseImageName = registry + "debezium/connect-base:" + debeziumContainerImageVersion;
        DEBEZIUM_CONTAINER = (DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)((DebeziumContainer)new DebeziumContainer((Future<String>)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile("debezium/connect-rest-test:" + debeziumVersion).withFileFromPath(".", Paths.get(System.getProperty("project.build.directory"), new String[0]))).withFileFromPath("Dockerfile", Paths.get(System.getProperty("project.basedir") + "/src/test/resources/Dockerfile.rest.test", new String[0]))).withBuildArg("BASE_IMAGE", baseImageName).withBuildArg("DEBEZIUM_VERSION", debeziumVersion)).withEnv("ENABLE_DEBEZIUM_SCRIPTING", "true")).withEnv("CONNECT_REST_EXTENSION_CLASSES", restExtensionClasses)).withNetwork(NETWORK)).withKafka(KAFKA_CONTAINER.getNetwork(), "kafka-dbz-ui:9092").withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER))).enableJMX().dependsOn(new Startable[]{KAFKA_CONTAINER});
    }

    public static GenericContainer<?> getKafkaContainer() {
        return KAFKA_CONTAINER;
    }

    public static DebeziumContainer getDebeziumContainer() {
        return DEBEZIUM_CONTAINER;
    }

    public static PostgreSQLContainer<?> getPostgresContainer() {
        return POSTGRES_CONTAINER;
    }

    public static MySQLContainer<?> getMySqlContainer() {
        return MYSQL_CONTAINER;
    }

    public static MongoDbReplicaSet getMongoDbContainer() {
        return MONGODB_REPLICA;
    }

    public static MSSQLServerContainer<?> getSqlServerContainer() {
        return SQL_SERVER_CONTAINER;
    }

    public static OracleContainer getOracleContainer() {
        return ORACLE_CONTAINER;
    }

    public static MariaDBContainer getMariaDbContainer() {
        return MARIADB_CONTAINER;
    }

    public static void waitForConnectorTaskStatus(String connectorName, int taskNumber, Connector.State state) {
        Awaitility.await().atMost(120L, TimeUnit.SECONDS).until(() -> RestExtensionTestInfrastructure.getDebeziumContainer().getConnectorTaskState(connectorName, taskNumber) == state);
    }

    public static enum DATABASE {
        POSTGRES,
        MYSQL,
        SQLSERVER,
        MONGODB,
        ORACLE,
        MARIADB,
        NONE;

    }
}

