/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeDns {
    private static final Logger LOGGER = LoggerFactory.getLogger(FakeDns.class);
    private static final FakeDns instance = new FakeDns();
    private final Map<String, InetAddress> forwardResolutions = new HashMap<String, InetAddress>();
    private Object originalNameService = null;
    private boolean installed = false;

    private FakeDns() {
    }

    public static FakeDns getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResolution(String hostname, InetAddress ip) {
        FakeDns fakeDns = this;
        synchronized (fakeDns) {
            this.forwardResolutions.put(hostname, ip);
        }
        LOGGER.info("Added dns resolution: {} -> {}", (Object)hostname, (Object)ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResolution(String hostname, InetAddress ip) {
        FakeDns fakeDns = this;
        synchronized (fakeDns) {
            this.forwardResolutions.remove(hostname, ip);
        }
        LOGGER.info("Removed dns resolution: {} -> {}", (Object)hostname, (Object)ip);
    }

    public synchronized boolean isInstalled() {
        return this.installed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FakeDns install() {
        FakeDns fakeDns = this;
        synchronized (fakeDns) {
            if (this.installed) {
                return this;
            }
            try {
                this.originalNameService = this.installDns();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.installed = true;
        }
        LOGGER.info("FakeDns is now ENABLED in JVM Runtime");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FakeDns restore() {
        FakeDns fakeDns = this;
        synchronized (fakeDns) {
            if (!this.installed) {
                return this;
            }
            try {
                this.restoreDns(this.originalNameService);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.installed = false;
        }
        LOGGER.info("FakeDns is now DISABLED in JVM Runtime");
        return this;
    }

    private Object installDns() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchFieldException {
        Class<?> nameServiceInterface = Class.forName("java.net.InetAddress$NameService");
        Field field = InetAddress.class.getDeclaredField("nameService");
        Method method = InetAddress.class.getDeclaredMethod("createNameService", new Class[0]);
        method.setAccessible(true);
        Object fallbackNameService = method.invoke(null, new Object[0]);
        Object installedNameService = Proxy.newProxyInstance(nameServiceInterface.getClassLoader(), new Class[]{nameServiceInterface}, (InvocationHandler)new NameServiceListener(fallbackNameService));
        field.setAccessible(true);
        field.set(InetAddress.class, installedNameService);
        return fallbackNameService;
    }

    private void restoreDns(Object nameService) throws IllegalAccessException, NoSuchFieldException {
        Field field = InetAddress.class.getDeclaredField("nameService");
        field.setAccessible(true);
        field.set(InetAddress.class, nameService);
    }

    public static <T extends Throwable> void propagateIfPossible(Throwable throwable, Class<T> declaredType) throws T {
        if (declaredType.isInstance(throwable)) {
            throw (Throwable)declaredType.cast(throwable);
        }
    }

    private class NameServiceListener
    implements InvocationHandler {
        private final Object fallbackNameService;

        NameServiceListener(Object fallbackNameService) {
            this.fallbackNameService = fallbackNameService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
            InetAddress inetAddress;
            FakeDns fakeDns = FakeDns.this;
            synchronized (fakeDns) {
                inetAddress = FakeDns.this.forwardResolutions.get(host);
            }
            if (inetAddress != null) {
                return new InetAddress[]{inetAddress};
            }
            return this.invokeFallBackMethod("lookupAllHostAddr", InetAddress[].class, host);
        }

        private String getHostByAddr(byte[] addr) throws UnknownHostException {
            return this.invokeFallBackMethod("getHostsByAddr", String.class, addr);
        }

        private <T, P> T invokeFallBackMethod(String methodName, Class<T> returnType, P param) throws UnknownHostException {
            try {
                Method method = this.fallbackNameService.getClass().getDeclaredMethod(methodName, param.getClass());
                method.setAccessible(true);
                Object result = method.invoke(this.fallbackNameService, param);
                return returnType.cast(result);
            }
            catch (ReflectiveOperationException | SecurityException e) {
                FakeDns.propagateIfPossible(e.getCause(), UnknownHostException.class);
                throw new AssertionError("unexpected reflection issue", e);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "lookupAllHostAddr": {
                    return this.lookupAllHostAddr((String)args[0]);
                }
                case "getHostByAddr": {
                    return this.getHostByAddr((byte[])args[0]);
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

