/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.SyncDockerCmd;
import com.github.dockerjava.api.model.ContainerNetwork;
import io.debezium.testing.testcontainers.util.DockerUtils;
import io.debezium.testing.testcontainers.util.PortResolver;
import io.debezium.testing.testcontainers.util.RandomPortResolver;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.utility.DockerImageName;

public class MongoDbContainer
extends GenericContainer<MongoDbContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbContainer.class);
    public static final String IMAGE_VERSION = System.getProperty("version.mongo.server", "6.0");
    private static final DockerImageName IMAGE_NAME = DockerImageName.parse((String)("mongo:" + IMAGE_VERSION));
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String name;
    private final int port;
    private final String replicaSet;
    private final PortResolver portResolver;

    public static Builder node() {
        return new Builder();
    }

    private MongoDbContainer(Builder builder) {
        super(IMAGE_NAME);
        this.name = builder.name;
        this.replicaSet = builder.replicaSet;
        this.portResolver = builder.portResolver;
        if (DockerUtils.isDockerDesktop()) {
            this.port = this.portResolver.resolveFreePort();
            this.addFixedExposedPort(this.port, this.port);
        } else {
            this.port = builder.port;
        }
        DockerUtils.logDockerDesktopBanner(LOGGER, List.of(this.name), builder.skipDockerDesktopLogWarning);
        this.withNetwork(builder.network);
        this.withNetworkAliases(new String[]{this.name});
        this.withCommand(new String[]{"--replSet", this.replicaSet, "--port", String.valueOf(this.port), "--bind_ip", "localhost," + this.name});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)"(?i).*waiting for connections.*", (int)1));
    }

    public Address getClientAddress() {
        this.checkStarted();
        if (DockerUtils.isDockerDesktop()) {
            return this.getNamedAddress();
        }
        return new Address(this.getNetworkIp(), this.port);
    }

    public Address getNamedAddress() {
        return new Address(this.name, this.port);
    }

    public void initReplicaSet(boolean configServer, Address ... Addresses2) {
        LOGGER.info("[{}:{}] Initializing replica set...", (Object)this.replicaSet, (Object)this.name);
        this.eval("rs.initiate({_id:'" + this.replicaSet + "',configsvr:" + configServer + ",members:[" + IntStream.range(0, Addresses2.length).mapToObj(i -> "{_id:" + i + ",host:'" + Addresses2[i] + "'}").collect(Collectors.joining(",")) + "]})");
    }

    public void stepDown() {
        LOGGER.info("[{}:{}] Stepping down...", (Object)this.replicaSet, (Object)this.name);
        this.eval("rs.stepDown()");
    }

    public void kill() {
        LOGGER.info("[{}:{}] Killing...", (Object)this.replicaSet, (Object)this.name);
        this.dockerCommand(client -> client.killContainerCmd(this.getContainerId()));
    }

    public void pause() {
        LOGGER.info("[{}:{}] Pausing...", (Object)this.replicaSet, (Object)this.name);
        this.dockerCommand(client -> client.pauseContainerCmd(this.getContainerId()));
    }

    public void unpause() {
        LOGGER.info("[{}:{}] Unpausing...", (Object)this.replicaSet, (Object)this.name);
        this.dockerCommand(client -> client.unpauseContainerCmd(this.getContainerId()));
    }

    private String getNetworkIp() {
        InspectContainerResponse info = this.getContainerInfo();
        return info.getNetworkSettings().getNetworks().values().stream().findFirst().map(ContainerNetwork::getIpAddress).orElseThrow();
    }

    private void dockerCommand(Function<DockerClient, SyncDockerCmd<?>> action) {
        action.apply(DockerClientFactory.instance().client()).exec();
    }

    public JsonNode eval(String command) {
        this.checkStarted();
        try {
            String mongoCommand = "mongo --quiet --host " + this.name + " --port " + this.port + " --eval \"JSON.stringify(" + command + ")\"";
            Container.ExecResult result = this.execInContainer(new String[]{"sh", "-c", MongoDbContainer.isLegacy() ? mongoCommand : "mongosh " + mongoCommand});
            this.checkExitCode(result);
            String stdout = result.getStdout();
            JsonNode response = MongoDbContainer.parseResponse(stdout);
            LOGGER.info("{}:", (Object)response);
            return response;
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static JsonNode parseResponse(String stdout) {
        try {
            return OBJECT_MAPPER.readTree(stdout);
        }
        catch (IOException e) {
            LOGGER.warn("Could not parse the following text as JSON: {}", (Object)stdout, (Object)e);
            return OBJECT_MAPPER.createObjectNode();
        }
    }

    private void checkExitCode(Container.ExecResult result) {
        boolean ok;
        boolean bl = ok = result.getExitCode() == 0 || MongoDbContainer.isLegacy() && result.getExitCode() == 252;
        if (ok) {
            return;
        }
        String message = "An error occurred: " + result.getStderr();
        LOGGER.error(message);
        throw new IllegalStateException(message);
    }

    private void checkStarted() {
        if (this.getContainerId() == null) {
            throw new IllegalStateException("Cannot execute operation before calling `start`.");
        }
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        super.containerIsStarted(containerInfo);
        DockerUtils.addFakeDnsEntry(this.name);
    }

    protected void containerIsStopped(InspectContainerResponse containerInfo) {
        super.containerIsStopped(containerInfo);
        DockerUtils.removeFakeDnsEntry(this.name);
        this.portResolver.releasePort(this.port);
    }

    private static boolean isLegacy() {
        int major = Integer.parseInt(IMAGE_VERSION.substring(0, 1));
        return major <= 4;
    }

    public static final class Builder {
        private String name;
        private int port = 27017;
        private PortResolver portResolver = new RandomPortResolver();
        private String replicaSet;
        private Network network = Network.SHARED;
        private boolean skipDockerDesktopLogWarning = false;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder portResolver(PortResolver portResolver) {
            this.portResolver = portResolver;
            return this;
        }

        public Builder replicaSet(String replicaSet) {
            this.replicaSet = replicaSet;
            return this;
        }

        public Builder network(Network network) {
            this.network = network;
            return this;
        }

        public Builder skipDockerDesktopLogWarning(boolean skipDockerDesktopLogWarning) {
            this.skipDockerDesktopLogWarning = skipDockerDesktopLogWarning;
            return this;
        }

        public MongoDbContainer build() {
            return new MongoDbContainer(this);
        }
    }

    public static class Address {
        private final String host;
        private final int port;

        public Address(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            return this.host + ":" + this.port;
        }
    }
}

