/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ConnectorResolver {
    private static final Map<String, String> CONNECTORS_BY_DRIVER;

    public static String getConnectorByJdbcDriver(String jdbcDriver) {
        if (CONNECTORS_BY_DRIVER.containsKey(jdbcDriver)) {
            return CONNECTORS_BY_DRIVER.get(jdbcDriver);
        }
        throw new IllegalArgumentException(String.format("%s JDBC driver is passed but only %s are supported.", jdbcDriver, CONNECTORS_BY_DRIVER.keySet().toString()));
    }

    static {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("org.postgresql.Driver", "io.debezium.connector.postgresql.PostgresConnector");
        tmp.put("com.mysql.cj.jdbc.Driver", "io.debezium.connector.mysql.MySqlConnector");
        tmp.put("com.mysql.jdbc.Driver", "io.debezium.connector.mysql.MySqlConnector");
        tmp.put("com.microsoft.sqlserver.jdbc.SQLServerDriver", "io.debezium.connector.sqlserver.SqlServerConnector");
        tmp.put("oracle.jdbc.OracleDriver", "io.debezium.connector.oracle.OracleConnector");
        tmp.put("com.ibm.db2.jcc.DB2Driver", "io.debezium.connector.db2.Db2Connector");
        CONNECTORS_BY_DRIVER = Collections.unmodifiableMap(tmp);
    }
}

