/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.debezium.testing.testcontainers.ConnectorResolver;
import java.util.List;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.MongoDBContainer;

public class ConnectorConfiguration {
    private final ObjectNode configNode;
    private static final String CONNECTOR = "connector.class";
    private static final String HOSTNAME = "database.hostname";
    private static final String HOSTS = "mongodb.hosts";
    private static final String PORT = "database.port";
    private static final String USER = "database.user";
    private static final String PASSWORD = "database.password";
    private static final String DBNAME = "database.dbname";
    private static final String AUTO_DISCOVER_MEMBERS = "mongodb.members.auto.discover";

    protected ConnectorConfiguration() {
        ObjectMapper mapper = new ObjectMapper();
        this.configNode = mapper.createObjectNode();
        this.configNode.put("tasks.max", 1);
    }

    public static ConnectorConfiguration create() {
        return new ConnectorConfiguration();
    }

    static ConnectorConfiguration from(JsonNode configNode) {
        ConnectorConfiguration configuration = new ConnectorConfiguration();
        configNode.fields().forEachRemaining(e -> configuration.configNode.set((String)e.getKey(), (JsonNode)e.getValue()));
        return configuration;
    }

    public static ConnectorConfiguration forJdbcContainer(JdbcDatabaseContainer<?> jdbcDatabaseContainer) {
        ConnectorConfiguration configuration = new ConnectorConfiguration();
        configuration.with(HOSTNAME, jdbcDatabaseContainer.getContainerInfo().getConfig().getHostName());
        List exposedPorts = jdbcDatabaseContainer.getExposedPorts();
        configuration.with(PORT, (Integer)exposedPorts.get(0));
        configuration.with(USER, jdbcDatabaseContainer.getUsername());
        configuration.with(PASSWORD, jdbcDatabaseContainer.getPassword());
        String driverClassName = jdbcDatabaseContainer.getDriverClassName();
        configuration.with(CONNECTOR, ConnectorResolver.getConnectorByJdbcDriver(driverClassName));
        if (!ConnectorConfiguration.isMySQL(driverClassName)) {
            configuration.with(DBNAME, jdbcDatabaseContainer.getDatabaseName());
        }
        return configuration;
    }

    public static ConnectorConfiguration forMongoDbContainer(MongoDBContainer mongoDbContainer) {
        List exposedPorts = mongoDbContainer.getExposedPorts();
        ConnectorConfiguration configuration = new ConnectorConfiguration();
        configuration.with(CONNECTOR, "io.debezium.connector.mongodb.MongoDbConnector").with(HOSTS, "rs0/" + mongoDbContainer.getContainerInfo().getConfig().getHostName() + ":" + exposedPorts.get(0)).with(AUTO_DISCOVER_MEMBERS, false);
        return configuration;
    }

    private static boolean isMySQL(String driverClassName) {
        return "com.mysql.cj.jdbc.Driver".equals(driverClassName) || "com.mysql.jdbc.Driver".equals(driverClassName);
    }

    public ConnectorConfiguration with(String key, String value) {
        this.configNode.put(key, value);
        return this;
    }

    public ConnectorConfiguration with(String key, Integer value) {
        this.configNode.put(key, value);
        return this;
    }

    public ConnectorConfiguration with(String key, Long value) {
        this.configNode.put(key, value);
        return this;
    }

    public ConnectorConfiguration with(String key, Boolean value) {
        this.configNode.put(key, value);
        return this;
    }

    public ConnectorConfiguration with(String key, Double value) {
        this.configNode.put(key, value);
        return this;
    }

    ObjectNode getConfiguration() {
        return this.configNode;
    }
}

