/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import io.debezium.testing.testcontainers.ConnectorConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.lifecycle.Startables;
import org.testcontainers.utility.DockerImageName;

public class PostgresInfrastructure {
    protected static final String POSTGRES_DEFAULT_IMAGE = "postgres:9.6.19";
    protected static final String POSTGRES_DEFAULT_DEBEZIUM_IMAGE = "debezium/example-postgres:1.3";
    protected static final Map<String, PostgresInfrastructure> postgresInfrastructures = new HashMap<String, PostgresInfrastructure>();
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresInfrastructure.class);
    protected final String postgresImageName;
    protected final Network network = Network.newNetwork();
    private final PostgreSQLContainer<?> postgresContainer;

    private PostgresInfrastructure(String postgresImageName) {
        DockerImageName postgresDockerImageName = DockerImageName.parse((String)postgresImageName).asCompatibleSubstituteFor("postgres");
        this.postgresImageName = postgresImageName;
        this.postgresContainer = (PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(postgresDockerImageName).withNetwork(this.network)).withDatabaseName("postgres").withUsername("postgres").withPassword("postgres").withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER))).withNetworkAliases(new String[]{"postgres"});
    }

    public static PostgresInfrastructure getDebeziumPostgresInfrastructure() {
        return new PostgresInfrastructure(POSTGRES_DEFAULT_DEBEZIUM_IMAGE);
    }

    public static PostgresInfrastructure getPostgresInfrastructure() {
        return new PostgresInfrastructure(POSTGRES_DEFAULT_IMAGE);
    }

    public static PostgresInfrastructure getInfrastructure(String postgresImage) {
        if (postgresInfrastructures.containsKey(postgresImage)) {
            return postgresInfrastructures.get(postgresImage);
        }
        PostgresInfrastructure infrastructure = new PostgresInfrastructure(postgresImage);
        postgresInfrastructures.put(postgresImage, infrastructure);
        return infrastructure;
    }

    public String getPostgresImageName() {
        return this.postgresImageName;
    }

    public PostgreSQLContainer<?> getPostgresContainer() {
        return this.postgresContainer;
    }

    public void startContainer() {
        Startables.deepStart(Stream.of(this.postgresContainer)).join();
    }

    public ConnectorConfiguration getPostgresConnectorConfiguration(int id, String ... options) {
        ConnectorConfiguration config = ConnectorConfiguration.forJdbcContainer(this.postgresContainer).with("database.server.name", "dbserver" + id).with("slot.name", "debezium_" + id);
        if (options != null && options.length > 0) {
            for (int i = 0; i < options.length; i += 2) {
                config.with(options[i], options[i + 1]);
            }
        }
        return config;
    }
}

