/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka.docker;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.kafka.docker.KafkaContainer;
import java.time.Duration;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.lifecycle.Startable;

public class KafkaConnectConainer
extends GenericContainer<KafkaConnectConainer> {
    public static final String KAFKA_CONNECT_COMMAND = "kafka-connect";
    public static final String KAFKA_JMX_HOST = "0.0.0.0";
    public static final int KAFKA_CONNECT_API_PORT = 8083;
    public static final int PROMETHEUS_METRICS_PORT = 9404;
    public static final int KAFKA_JMX_PORT = 9999;

    public KafkaConnectConainer(String containerImageName) {
        super(containerImageName);
        this.defaultConfig();
    }

    public KafkaConnectConainer() {
        this(ConfigProperties.DOCKER_IMAGE_KAFKA_RHEL);
    }

    private void defaultConfig() {
        this.withReuse(false);
        this.withExposedPorts(new Integer[]{8083, 9999});
        this.addEnv("CONFIG_STORAGE_TOPIC", "connect_config");
        this.addEnv("OFFSET_STORAGE_TOPIC", "connect_offsets");
        this.addEnv("STATUS_STORAGE_TOPIC", "connect_statuses");
        this.addEnv("JMXHOST", KAFKA_JMX_HOST);
        this.addEnv("JMXPORT", String.valueOf(9999));
        this.withHttpMetrics();
        this.withStartupTimeout(Duration.ofMinutes(WaitConditions.scaled(3L)));
        this.withCommand(KAFKA_CONNECT_COMMAND);
    }

    public KafkaConnectConainer withKafka(KafkaContainer kafka) {
        return ((KafkaConnectConainer)this.dependsOn(new Startable[]{kafka})).withKafka(kafka.getNetwork(), kafka.getBootstrapAddress());
    }

    public KafkaConnectConainer withKafka(Network network, String bootstrapServers) {
        return (KafkaConnectConainer)((KafkaConnectConainer)this.withNetwork(network)).withEnv("BOOTSTRAP_SERVERS", bootstrapServers);
    }

    public KafkaConnectConainer withHttpMetrics() {
        this.addEnv("ENABLE_JMX_EXPORTER", "true");
        this.addExposedPort(9404);
        return this;
    }
}

