/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.mariadb;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.YAML;
import io.debezium.testing.system.tools.databases.AbstractOcpDatabaseDeployer;
import io.debezium.testing.system.tools.databases.mariadb.MariaDbController;
import io.debezium.testing.system.tools.databases.mariadb.OcpMariaDbController;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OcpMariaDbDeployer
extends AbstractOcpDatabaseDeployer<MariaDbController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpMariaDbDeployer.class);
    private final PersistentVolumeClaim volumeClaim;

    private OcpMariaDbDeployer(String project, Deployment deployment, List<Service> services, Secret pullSecret, PersistentVolumeClaim volumeClaim, OpenShiftClient ocp) {
        super(project, deployment, services, pullSecret, ocp);
        this.volumeClaim = volumeClaim;
    }

    @Override
    public MariaDbController deploy() {
        PersistentVolumeClaim ocpPvc = (PersistentVolumeClaim)((Resource)((NonNamespaceOperation)this.ocp.persistentVolumeClaims().inNamespace(ConfigProperties.OCP_PROJECT_MARIADB)).withName(this.volumeClaim.getMetadata().getName())).get();
        if (ocpPvc == null) {
            LOGGER.info("Deploying persistent volume claim");
            ((NonNamespaceOperation)this.ocp.persistentVolumeClaims().inNamespace(ConfigProperties.OCP_PROJECT_MARIADB)).createOrReplace((Object)this.volumeClaim);
        } else {
            LOGGER.info("Persistent volume claim already exists. Skipping deployment");
        }
        return (MariaDbController)super.deploy();
    }

    @Override
    public OcpMariaDbController getController(Deployment deployment, List<Service> services, OpenShiftClient ocp) {
        return new OcpMariaDbController(deployment, services, "mariadb", ocp);
    }

    public static class Deployer
    extends AbstractOcpDatabaseDeployer.DatabaseBuilder<Deployer, OcpMariaDbDeployer> {
        private PersistentVolumeClaim volumeClaim;

        public Deployer withVolumeClaim(String dbVolumeClaimPath) {
            this.volumeClaim = YAML.fromResource(dbVolumeClaimPath, PersistentVolumeClaim.class);
            return (Deployer)this.self();
        }

        @Override
        public OcpMariaDbDeployer build() {
            return new OcpMariaDbDeployer(this.project, this.deployment, this.services, this.pullSecret, this.volumeClaim, this.ocpClient);
        }
    }
}

