/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka;

import io.debezium.testing.system.tools.AbstractOcpDeployer;
import io.debezium.testing.system.tools.kafka.OcpKafkaController;
import io.debezium.testing.system.tools.kafka.StrimziOperatorController;
import io.debezium.testing.system.tools.kafka.builders.FabricKafkaBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.client.OpenShiftClient;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.model.kafka.Kafka;
import io.strimzi.api.kafka.model.kafka.KafkaList;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePool;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolList;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OcpKafkaDeployer
extends AbstractOcpDeployer<OcpKafkaController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpKafkaDeployer.class);
    private final FabricKafkaBuilder strimziBuilder;
    private final StrimziOperatorController operatorController;

    public OcpKafkaDeployer(String project, FabricKafkaBuilder strimziBuilder, StrimziOperatorController operatorController, OpenShiftClient ocp, OkHttpClient http) {
        super(project, ocp, http);
        this.strimziBuilder = strimziBuilder;
        this.operatorController = operatorController;
    }

    @Override
    public OcpKafkaController deploy() throws InterruptedException {
        LOGGER.info("Deploying Kafka Cluster");
        Kafka kafka = (Kafka)this.kafkaOperation().createOrReplace((Object)this.strimziBuilder.build());
        OcpKafkaController controller = new OcpKafkaController(kafka, this.operatorController, this.ocp);
        if (FabricKafkaBuilder.shouldKRaftBeUsed()) {
            LOGGER.info("Deploying Kafka Node Pool");
            KafkaNodePool nodePool = this.strimziBuilder.defaultKafkaNodePool();
            this.nodePoolOperation().createOrReplace((Object)nodePool);
        }
        controller.waitForCluster();
        return controller;
    }

    private NonNamespaceOperation<Kafka, KafkaList, Resource<Kafka>> kafkaOperation() {
        return (NonNamespaceOperation)Crds.kafkaOperation((KubernetesClient)this.ocp).inNamespace(this.project);
    }

    private NonNamespaceOperation<KafkaNodePool, KafkaNodePoolList, Resource<KafkaNodePool>> nodePoolOperation() {
        return (NonNamespaceOperation)Crds.kafkaNodePoolOperation((KubernetesClient)this.ocp).inNamespace(this.project);
    }
}

