/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.postgresql;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.OcpSqlDatabaseController;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpPostgreSqlReplicaController
extends OcpSqlDatabaseController {
    private static final String INIT_SCRIPT_PATH = "/database-resources/postgresql/replica/schema_init.sql";
    private static final String INIT_SCRIPT_PATH_CONTAINER = "/init.sql";
    private final Path initScript;
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpPostgreSqlReplicaController.class);

    public OcpPostgreSqlReplicaController(Deployment deployment, List<Service> services, String dbType, OpenShiftClient ocp) {
        super(deployment, services, "postgresql", ocp);
        try {
            this.initScript = Paths.get(this.getClass().getResource(INIT_SCRIPT_PATH).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initialize() throws InterruptedException {
        super.initialize();
        Pod pod = (Pod)((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withLabel("deployment", this.name)).list()).getItems().get(0);
        ((PodResource)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withName(pod.getMetadata().getName())).file(INIT_SCRIPT_PATH_CONTAINER).upload(this.initScript);
        this.ocpUtils.executeCommand(this.deployment, this.project, true, "psql", "-U", ConfigProperties.DATABASE_POSTGRESQL_USERNAME, "-d", ConfigProperties.DATABASE_POSTGRESQL_DBZ_DBNAME, "-f", INIT_SCRIPT_PATH_CONTAINER);
    }
}

