/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.mongodb.sharded.componentproviders;

import io.debezium.testing.system.tools.ConfigProperties;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.ExecActionBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.fabric8.kubernetes.api.model.TCPSocketActionBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentStrategyBuilder;
import java.util.Map;

public class OcpShardModelProvider {
    public static Deployment shardDeployment(int shardNum, int replicaNum) {
        String name = OcpShardModelProvider.getShardNodeName(shardNum, replicaNum);
        ObjectMeta metaData = OcpShardModelProvider.getMetaData(shardNum, replicaNum);
        DeploymentBuilder builder = (DeploymentBuilder)((DeploymentBuilder)((DeploymentBuilder)((DeploymentBuilder)new DeploymentBuilder().withKind("Deployment")).withApiVersion("apps/v1")).withMetadata(metaData)).withSpec(((DeploymentSpecBuilder)((DeploymentSpecBuilder)((DeploymentSpecBuilder)((DeploymentSpecBuilder)new DeploymentSpecBuilder().withReplicas(Integer.valueOf(1))).withStrategy(((DeploymentStrategyBuilder)new DeploymentStrategyBuilder().withType("Recreate")).build())).withSelector(((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(metaData.getLabels())).build())).withTemplate(((PodTemplateSpecBuilder)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withLabels(metaData.getLabels())).build())).withSpec(((PodSpecBuilder)((PodSpecBuilder)new PodSpecBuilder().withVolumes(new Volume[]{((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName("volume-" + name)).withEmptyDir(new EmptyDirVolumeSource())).build()})).withContainers(new Container[]{((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("mongo")).withReadinessProbe(((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withExec(((ExecActionBuilder)new ExecActionBuilder().withCommand(new String[]{"mongosh", "localhost:27018"})).build())).withInitialDelaySeconds(Integer.valueOf(5))).build())).withPorts(new ContainerPort[]{((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withProtocol("TCP")).withContainerPort(Integer.valueOf(27018))).build()})).withImagePullPolicy("Always")).withLivenessProbe(((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withInitialDelaySeconds(Integer.valueOf(10))).withTcpSocket(((TCPSocketActionBuilder)new TCPSocketActionBuilder().withPort(new IntOrString((Object)27018))).build())).withTimeoutSeconds(Integer.valueOf(20))).build())).withTerminationMessagePolicy("File")).withTerminationMessagePath("/dev/termination-log")).withImage(ConfigProperties.DOCKER_IMAGE_MONGO_SHARDED)).withCommand(new String[]{"mongod", "--shardsvr", "--replSet", OcpShardModelProvider.getShardReplicaSetName(shardNum), "--dbpath", "/data/db", "--bind_ip_all"})).build()})).build())).build())).build());
        return builder.build();
    }

    public static Service shardService(int shardNum, int replicaNum) {
        ObjectMeta metaData = OcpShardModelProvider.getMetaData(shardNum, replicaNum);
        return ((ServiceBuilder)((ServiceBuilder)((ServiceBuilder)((ServiceBuilder)new ServiceBuilder().withKind("Service")).withApiVersion("v1")).withMetadata(metaData)).withSpec(((ServiceSpecBuilder)((ServiceSpecBuilder)new ServiceSpecBuilder().withSelector(metaData.getLabels())).withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("db")).withPort(Integer.valueOf(27018))).withTargetPort(new IntOrString((Object)27018))).build()})).build())).build();
    }

    public static String getShardNodeName(int shardNum, int replicaNum) {
        return "mongo-shard" + shardNum + "r" + replicaNum;
    }

    public static String getShardReplicaSetName(int shardNum) {
        return "mongo-shard" + shardNum + "rs";
    }

    private static ObjectMeta getMetaData(int shardNum, int replicaNum) {
        String name = OcpShardModelProvider.getShardNodeName(shardNum, replicaNum);
        return ((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(name)).withLabels(Map.of("app", "mongo", "deployment", name, "shard", String.valueOf(shardNum), "role", "mongo-shard"))).build();
    }
}

