/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.artifacts;

import io.debezium.testing.system.tools.AbstractOcpDeployer;
import io.debezium.testing.system.tools.Deployer;
import io.debezium.testing.system.tools.OpenShiftUtils;
import io.debezium.testing.system.tools.YAML;
import io.debezium.testing.system.tools.artifacts.OcpArtifactServerController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.client.OpenShiftClient;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpArtifactServerDeployer
extends AbstractOcpDeployer<OcpArtifactServerController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpArtifactServerDeployer.class);
    private final OpenShiftUtils ocpUtils;
    private Deployment deployment;
    private Service service;

    public OcpArtifactServerDeployer(String project, Deployment deployment, Service service, OpenShiftClient ocp, OkHttpClient http) {
        super(project, ocp, http);
        this.ocpUtils = new OpenShiftUtils(ocp);
        this.deployment = deployment;
        this.service = service;
    }

    @Override
    public OcpArtifactServerController deploy() throws Exception {
        LOGGER.info("Deploying debezium artifact server");
        this.deployment = (Deployment)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).createOrReplace((Object)this.deployment);
        this.service.getMetadata().setLabels(this.deployment.getMetadata().getLabels());
        this.service = (Service)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).createOrReplace((Object)this.service);
        OcpArtifactServerController controller = new OcpArtifactServerController(this.deployment, this.service, this.ocp, this.http);
        controller.waitForServer();
        return controller;
    }

    public static class Builder
    implements Deployer.Builder<Builder, OcpArtifactServerDeployer> {
        private String project;
        private OpenShiftClient ocpClient;
        private OkHttpClient httpClient;
        private Deployment deployment;
        private Service service;

        public Builder withProject(String project) {
            this.project = project;
            return (Builder)this.self();
        }

        public Builder withOcpClient(OpenShiftClient ocpClient) {
            this.ocpClient = ocpClient;
            return (Builder)this.self();
        }

        public Builder withHttpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return (Builder)this.self();
        }

        public Builder withDeployment(String yamlPath) {
            this.deployment = YAML.fromResource(yamlPath, Deployment.class);
            return (Builder)this.self();
        }

        public Builder withService(String yamlPath) {
            this.service = YAML.fromResource(yamlPath, Service.class);
            return (Builder)this.self();
        }

        @Override
        public OcpArtifactServerDeployer build() {
            return new OcpArtifactServerDeployer(this.project, this.deployment, this.service, this.ocpClient, this.httpClient);
        }
    }
}

