/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.artifacts;

import io.debezium.testing.system.tools.OpenShiftUtils;
import io.debezium.testing.system.tools.WaitConditions;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.CopyOrReadable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.openshift.client.OpenShiftClient;
import io.strimzi.api.kafka.model.connect.build.Artifact;
import io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder;
import io.strimzi.api.kafka.model.connect.build.Plugin;
import io.strimzi.api.kafka.model.connect.build.PluginBuilder;
import io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpArtifactServerController {
    public static final Logger LOGGER = LoggerFactory.getLogger(OcpArtifactServerController.class);
    private final Deployment deployment;
    private final String project;
    private final Service service;
    private final OpenShiftClient ocp;
    private final OkHttpClient http;
    private final Map<String, HttpUrl> artifacts;
    private final OpenShiftUtils ocpUtils;

    public OcpArtifactServerController(Deployment deployment, Service service, OpenShiftClient ocp, OkHttpClient http) throws IOException {
        this.deployment = deployment;
        this.project = deployment.getMetadata().getNamespace();
        this.service = service;
        this.ocp = ocp;
        this.ocpUtils = new OpenShiftUtils(ocp);
        this.http = http;
        this.artifacts = this.listArtifacts();
    }

    public HttpUrl getBaseUrl() {
        return new HttpUrl.Builder().scheme("http").host(this.service.getMetadata().getName() + "." + this.service.getMetadata().getNamespace() + ".svc.cluster.local").port(8080).build();
    }

    private HttpUrl createArtifactUrl(String link) {
        return this.getBaseUrl().resolve(link);
    }

    public Optional<HttpUrl> geArtifactUrl(String name) {
        return Optional.ofNullable(this.artifacts.get(name));
    }

    public Optional<String> getArtifactUrlAsString(String name) {
        return this.geArtifactUrl(name).map(HttpUrl::toString);
    }

    private Artifact createArtifact(String url) {
        String type;
        Objects.requireNonNull(url);
        switch (type = url.substring(url.lastIndexOf(46) + 1)) {
            case "zip": {
                return ((ZipArtifactBuilder)new ZipArtifactBuilder().withUrl(url)).build();
            }
            case "jar": {
                return ((JarArtifactBuilder)new JarArtifactBuilder().withUrl(url)).build();
            }
        }
        throw new IllegalStateException("Unsupported artifact type: " + type);
    }

    public Plugin createPlugin(String name, List<String> artifacts) {
        List pluginArtifacts = artifacts.stream().map(this::getArtifactUrlAsString).map(a -> (String)a.orElseThrow(() -> new IllegalStateException("Missing artifact for plugin'" + name + "'"))).map(this::createArtifact).collect(Collectors.toList());
        return ((PluginBuilder)((PluginBuilder)new PluginBuilder().withName(name)).withArtifacts(pluginArtifacts)).build();
    }

    public Plugin createDebeziumPlugin(String database) {
        return this.createDebeziumPlugin(database, List.of());
    }

    public Plugin createDebeziumPlugin(String database, List<String> extraArtifacts) {
        List<String> commonArtifacts = List.of("debezium-connector-" + database, "debezium-scripting", "connect-converter", "groovy/groovy", "groovy/groovy-json", "groovy/groovy-jsr223");
        List<String> artifacts = Stream.concat(commonArtifacts.stream(), extraArtifacts.stream()).collect(Collectors.toList());
        return this.createPlugin("debezium-connector-" + database, artifacts);
    }

    public List<String> readArtifactListing() throws IOException {
        return (List)Awaitility.await().pollInterval(5L, TimeUnit.SECONDS).atMost(WaitConditions.scaled(1L), TimeUnit.MINUTES).ignoreExceptions().until(this::tryReadingArtifactListing, result -> !result.isEmpty());
    }

    private List<String> tryReadingArtifactListing() throws IOException {
        LOGGER.info("Trying to read listing from artifact server");
        Pod pod = this.ocpUtils.podsForDeployment(this.deployment).get(0);
        try (InputStream is = (InputStream)((CopyOrReadable)((ContainerResource)((PodResource)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withName(pod.getMetadata().getName())).inContainer((Object)"debezium-artifact-server")).file("/opt/plugins/artifacts.txt")).read();){
            String listing = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            List<String> list = listing.lines().collect(Collectors.toList());
            return list;
        }
    }

    public Map<String, HttpUrl> listArtifacts() throws IOException {
        List<String> listing = this.readArtifactListing();
        return listing.stream().map(l -> l.split("::", 2)).collect(Collectors.toMap(e -> e[0], e -> this.createArtifactUrl(e[1])));
    }

    public void waitForServer() {
        LOGGER.info("Waiting for Artifact Server");
        ((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName(this.deployment.getMetadata().getName())).waitUntilCondition(WaitConditions::deploymentAvailableCondition, WaitConditions.scaled(5L), TimeUnit.MINUTES);
    }
}

