/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools;

import io.debezium.testing.system.tools.WaitConditions;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtils.class);
    private final OkHttpClient http;

    public HttpUtils(OkHttpClient http) {
        this.http = http;
    }

    public void awaitApi(HttpUrl url) {
        LOGGER.info("Waiting for API at " + url);
        Awaitility.await().atMost(WaitConditions.scaled(1L), TimeUnit.MINUTES).ignoreException(IOException.class).until(() -> this.pingApi(url));
    }

    private boolean pingApi(HttpUrl address) throws IOException {
        Request r = new Request.Builder().url(address).build();
        try (Response res = this.http.newCall(r).execute();){
            boolean bl = res.isSuccessful();
            return bl;
        }
    }
}

