/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.oracle;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.databases.DatabaseInitListener;
import io.debezium.testing.system.tools.databases.OcpSqlDatabaseController;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.CopyOrReadable;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.openshift.client.OpenShiftClient;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpOracleController
extends OcpSqlDatabaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpOracleController.class);
    private static final String DB_INIT_SCRIPT_PATH = "/database-resources/oracle/inventory.sql";
    private static final String DB_INIT_SCRIPT_PATH_CONTAINER = "/home/oracle/inventory.sql";
    private final Path initScript;

    public OcpOracleController(Deployment deployment, List<Service> services, OpenShiftClient ocp) {
        super(deployment, services, "oracle", ocp);
        try {
            this.initScript = Paths.get(this.getClass().getResource(DB_INIT_SCRIPT_PATH).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initialize() throws InterruptedException {
        Pod pod = (Pod)((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withLabel("deployment", this.name)).list()).getItems().get(0);
        LOGGER.info("Uploading inventory.sql to /home/oracle/inventory.sql");
        ((CopyOrReadable)((PodResource)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withName(pod.getMetadata().getName())).file(DB_INIT_SCRIPT_PATH_CONTAINER)).upload(this.initScript);
        CountDownLatch latch = new CountDownLatch(1);
        try (ExecWatch exec = (ExecWatch)((Execable)((TtyExecErrorChannelable)((TtyExecErrorable)((ContainerResource)((PodResource)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withName(pod.getMetadata().getName())).inContainer((Object)"oracle")).writingOutput((Object)System.out)).writingError((Object)System.err)).usingListener((Object)new DatabaseInitListener("oracle", latch))).exec((Object[])new String[]{"sqlplus", "-S", ConfigProperties.DATABASE_ORACLE_USERNAME + "/" + ConfigProperties.DATABASE_ORACLE_PASSWORD + "@//localhost:1521/ORCLPDB1", "@/home/oracle/inventory.sql"});){
            LOGGER.info("Waiting until database is initialized");
            latch.await(WaitConditions.scaled(1L), TimeUnit.MINUTES);
        }
    }

    @Override
    public String getPublicDatabaseUrl() {
        return "jdbc:oracle:thin:@" + this.getPublicDatabaseHostname() + ":" + this.getPublicDatabasePort() + "/" + ConfigProperties.DATABASE_ORACLE_PDBNAME;
    }
}

