/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka.builders.kafka;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.kafka.builders.kafka.StrimziBuilderWrapper;
import io.debezium.testing.system.tools.kafka.builders.kafka.StrimziKafkaBuilder;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelectorBuilder;
import io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluent;
import io.strimzi.api.kafka.model.CertSecretSource;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.ClientTls;
import io.strimzi.api.kafka.model.ClientTlsBuilder;
import io.strimzi.api.kafka.model.ContainerEnvVar;
import io.strimzi.api.kafka.model.ContainerEnvVarBuilder;
import io.strimzi.api.kafka.model.ExternalLoggingFluent;
import io.strimzi.api.kafka.model.JmxPrometheusExporterMetricsFluent;
import io.strimzi.api.kafka.model.KafkaConnect;
import io.strimzi.api.kafka.model.KafkaConnectBuilder;
import io.strimzi.api.kafka.model.KafkaConnectFluent;
import io.strimzi.api.kafka.model.KafkaConnectSpecFluent;
import io.strimzi.api.kafka.model.connect.build.Artifact;
import io.strimzi.api.kafka.model.connect.build.BuildFluent;
import io.strimzi.api.kafka.model.connect.build.JarArtifactBuilder;
import io.strimzi.api.kafka.model.connect.build.PluginBuilder;
import io.strimzi.api.kafka.model.connect.build.ZipArtifactBuilder;
import io.strimzi.api.kafka.model.template.ContainerTemplateBuilder;
import io.strimzi.api.kafka.model.template.KafkaConnectTemplate;
import io.strimzi.api.kafka.model.template.KafkaConnectTemplateBuilder;
import io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StrimziKafkaConnectBuilder
extends StrimziBuilderWrapper<StrimziKafkaConnectBuilder, KafkaConnectBuilder, KafkaConnect> {
    public static String DEFAULT_KC_NAME = "debezium-kafka-connect-cluster";
    public static String DEFAULT_BOOSTRAP_SERVER = StrimziKafkaBuilder.DEFAULT_KAFKA_NAME + "-kafka-bootstrap:9093";

    protected StrimziKafkaConnectBuilder(KafkaConnectBuilder builder) {
        super(builder);
    }

    @Override
    public KafkaConnect build() {
        return ((KafkaConnectBuilder)this.builder).build();
    }

    public boolean hasBuild() {
        return ((KafkaConnectBuilder)this.builder).editSpec().hasBuild();
    }

    public Optional<String> imageStream() {
        if (!this.hasBuild()) {
            return Optional.empty();
        }
        String image = ((KafkaConnectBuilder)this.builder).editSpec().editBuild().buildOutput().getImage();
        return Optional.of(image);
    }

    public static StrimziKafkaConnectBuilder base() {
        Map<String, Object> config = StrimziKafkaConnectBuilder.defaultConfig();
        KafkaConnectTemplate template = StrimziKafkaConnectBuilder.defaultTemplate();
        ClientTls tls = StrimziKafkaConnectBuilder.defaultTLS();
        KafkaConnectBuilder builder = (KafkaConnectBuilder)((KafkaConnectFluent.SpecNested)((KafkaConnectFluent.SpecNested)((KafkaConnectFluent.SpecNested)((KafkaConnectFluent.SpecNested)((KafkaConnectFluent.SpecNested)((KafkaConnectBuilder)((KafkaConnectFluent.MetadataNested)new KafkaConnectBuilder().withNewMetadata().withName(DEFAULT_KC_NAME)).endMetadata()).withNewSpec().withBootstrapServers(DEFAULT_BOOSTRAP_SERVER)).withTemplate(template)).withConfig(config)).withReplicas(Integer.valueOf(1))).withTls(tls)).endSpec();
        return new StrimziKafkaConnectBuilder(builder);
    }

    public StrimziKafkaConnectBuilder withImage(String image) {
        ((KafkaConnectFluent.SpecNested)((KafkaConnectBuilder)this.builder).editSpec().withImage(image)).endSpec();
        return (StrimziKafkaConnectBuilder)this.self();
    }

    public StrimziKafkaConnectBuilder withBuild() {
        ((KafkaConnectFluent.SpecNested)((KafkaConnectSpecFluent.BuildNested)((BuildFluent.ImageStreamOutputNested)((KafkaConnectBuilder)this.builder).editSpec().withNewBuild().withNewImageStreamOutput().withImage("testing-openshift-connect:latest")).endImageStreamOutput()).endBuild()).endSpec();
        return (StrimziKafkaConnectBuilder)this.self();
    }

    public StrimziKafkaConnectBuilder withConnectorResources() {
        ((KafkaConnectFluent.MetadataNested)((KafkaConnectBuilder)this.builder).editMetadata().addToAnnotations("strimzi.io/use-connector-resources", "true")).endMetadata();
        return (StrimziKafkaConnectBuilder)this.self();
    }

    public StrimziKafkaConnectBuilder withStandardPlugins() {
        Map pluginBuilders = Stream.of("mysql", "postgres", "mongodb", "sqlserver", "db2", "oracle").collect(Collectors.toMap(Function.identity(), StrimziKafkaConnectBuilder::prepareStandardPluginBuilder));
        ((PluginBuilder)pluginBuilders.get("db2").addToArtifacts(new Artifact[]{((JarArtifactBuilder)new JarArtifactBuilder().withUrl(String.format("%s/jdbc/jcc-%s.jar", ConfigProperties.ARTIFACT_SERVER_URL, ConfigProperties.ARTIFACT_SERVER_DB2_DRIVER_VERSION))).build()})).build();
        ((PluginBuilder)pluginBuilders.get("oracle").addToArtifacts(new Artifact[]{((JarArtifactBuilder)new JarArtifactBuilder().withUrl(String.format("%s/jdbc/ojdbc8-%s.jar", ConfigProperties.ARTIFACT_SERVER_URL, ConfigProperties.ARTIFACT_SERVER_ORACLE_DRIVER_VERSION))).build()})).build();
        List plugins = pluginBuilders.values().stream().map(PluginBuilder::build).collect(Collectors.toList());
        ((KafkaConnectFluent.SpecNested)((KafkaConnectSpecFluent.BuildNested)((KafkaConnectBuilder)this.builder).editSpec().editBuild().withPlugins(plugins)).endBuild()).endSpec();
        return (StrimziKafkaConnectBuilder)this.self();
    }

    public StrimziKafkaConnectBuilder withPullSecret(String pullSecretName) {
        if (((KafkaConnectBuilder)this.builder).editSpec().hasImage().booleanValue()) {
            ((KafkaConnectFluent.SpecNested)((AbstractKafkaConnectSpecFluent.TemplateNested)((KafkaConnectTemplateFluent.PodNested)((KafkaConnectBuilder)this.builder).editSpec().editTemplate().editOrNewPod().addNewImagePullSecret(pullSecretName)).endPod()).endTemplate()).endSpec();
        }
        if (((KafkaConnectBuilder)this.builder).editSpec().hasBuild().booleanValue()) {
            ((KafkaConnectFluent.SpecNested)((AbstractKafkaConnectSpecFluent.TemplateNested)((KafkaConnectTemplateFluent.BuildConfigNested)((KafkaConnectBuilder)this.builder).editSpec().editTemplate().editOrNewBuildConfig().withPullSecret(pullSecretName)).endBuildConfig()).endTemplate()).endSpec();
        }
        return (StrimziKafkaConnectBuilder)this.self();
    }

    public StrimziKafkaConnectBuilder withLoggingFromConfigMap(ConfigMap configMap) {
        ConfigMapKeySelector configMapKeySelector = ((ConfigMapKeySelectorBuilder)((ConfigMapKeySelectorBuilder)new ConfigMapKeySelectorBuilder().withKey("log4j.properties")).withName(configMap.getMetadata().getName())).build();
        ((KafkaConnectFluent.SpecNested)((AbstractKafkaConnectSpecFluent.ExternalLoggingNested)((ExternalLoggingFluent.ValueFromNested)((KafkaConnectBuilder)this.builder).editSpec().withNewExternalLogging().withNewValueFrom().withConfigMapKeyRef(configMapKeySelector)).endValueFrom()).endExternalLogging()).endSpec();
        return (StrimziKafkaConnectBuilder)this.self();
    }

    public StrimziKafkaConnectBuilder withMetricsFromConfigMap(ConfigMap configMap) {
        ConfigMapKeySelector configMapKeySelector = ((ConfigMapKeySelectorBuilder)((ConfigMapKeySelectorBuilder)new ConfigMapKeySelectorBuilder().withKey("metrics")).withName(configMap.getMetadata().getName())).build();
        ((KafkaConnectFluent.SpecNested)((AbstractKafkaConnectSpecFluent.JmxPrometheusExporterMetricsConfigNested)((JmxPrometheusExporterMetricsFluent.ValueFromNested)((KafkaConnectBuilder)this.builder).editSpec().withNewJmxPrometheusExporterMetricsConfig().withNewValueFrom().withConfigMapKeyRef(configMapKeySelector)).endValueFrom()).endJmxPrometheusExporterMetricsConfig()).endSpec();
        return (StrimziKafkaConnectBuilder)this.self();
    }

    private static PluginBuilder prepareStandardPluginBuilder(String dbName) {
        return (PluginBuilder)((PluginBuilder)new PluginBuilder().withName("debezium-connector-" + dbName)).withArtifacts(new Artifact[]{((ZipArtifactBuilder)new ZipArtifactBuilder().withUrl(String.format("%s/debezium-connector-%s-%s-plugin.zip", ConfigProperties.ARTIFACT_SERVER_URL, dbName, ConfigProperties.ARTIFACT_SERVER_DBZ_VERSION))).build(), ((ZipArtifactBuilder)new ZipArtifactBuilder().withUrl(ConfigProperties.ARTIFACT_SERVER_APC_URL)).build(), ((ZipArtifactBuilder)new ZipArtifactBuilder().withUrl(String.format("%s/debezium-scripting-%s.zip", ConfigProperties.ARTIFACT_SERVER_URL, ConfigProperties.ARTIFACT_SERVER_DBZ_VERSION))).build()});
    }

    private static KafkaConnectTemplate defaultTemplate() {
        return ((KafkaConnectTemplateBuilder)new KafkaConnectTemplateBuilder().withConnectContainer(((ContainerTemplateBuilder)new ContainerTemplateBuilder().withEnv(new ContainerEnvVar[]{((ContainerEnvVarBuilder)((ContainerEnvVarBuilder)new ContainerEnvVarBuilder().withName("JMX_PORT")).withValue("5000")).build()})).build())).build();
    }

    private static ClientTls defaultTLS() {
        return ((ClientTlsBuilder)new ClientTlsBuilder().withTrustedCertificates(new CertSecretSource[]{((CertSecretSourceBuilder)((CertSecretSourceBuilder)new CertSecretSourceBuilder().withCertificate("ca.crt")).withSecretName("debezium-kafka-cluster-cluster-ca-cert")).build()})).build();
    }

    private static Map<String, Object> defaultConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("config.storage.replication.factor", 1);
        config.put("offset.storage.replication.factor", 1);
        config.put("status.storage.replication.factor", 1);
        return config;
    }
}

