/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka;

import io.debezium.testing.system.tools.AbstractOcpDeployer;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.Deployer;
import io.debezium.testing.system.tools.YAML;
import io.debezium.testing.system.tools.kafka.OcpKafkaConnectController;
import io.debezium.testing.system.tools.kafka.StrimziOperatorController;
import io.debezium.testing.system.tools.kafka.builders.kafka.StrimziKafkaConnectBuilder;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaConnectList;
import io.strimzi.api.kafka.model.KafkaConnect;
import java.util.Optional;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpKafkaConnectDeployer
extends AbstractOcpDeployer<OcpKafkaConnectController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpKafkaConnectDeployer.class);
    private final StrimziKafkaConnectBuilder strimziBuilder;
    private final ConfigMap configMap;
    private final StrimziOperatorController operatorController;

    private OcpKafkaConnectDeployer(String project, StrimziKafkaConnectBuilder strimziBuilder, ConfigMap configMap, StrimziOperatorController operatorController, OpenShiftClient ocp, OkHttpClient http) {
        super(project, ocp, http);
        this.strimziBuilder = strimziBuilder;
        this.configMap = configMap;
        this.operatorController = operatorController;
    }

    @Override
    public OcpKafkaConnectController deploy() throws InterruptedException {
        LOGGER.info("Deploying KafkaConnect");
        if (this.configMap != null) {
            this.deployConfigMap();
        }
        if (this.strimziBuilder.hasBuild()) {
            this.deployImageStream();
        }
        KafkaConnect kafkaConnect = this.strimziBuilder.build();
        kafkaConnect = (KafkaConnect)this.kafkaConnectOperation().createOrReplace((Object[])new KafkaConnect[]{kafkaConnect});
        OcpKafkaConnectController controller = new OcpKafkaConnectController(kafkaConnect, this.operatorController, this.ocp, this.http);
        controller.waitForCluster();
        return controller;
    }

    private void deployConfigMap() {
        ((NonNamespaceOperation)this.ocp.configMaps().inNamespace(this.project)).createOrReplace((Object[])new ConfigMap[]{this.configMap});
    }

    private void deployImageStream() {
        Optional<String> imageStream = this.strimziBuilder.imageStream();
        if (!imageStream.isPresent()) {
            throw new IllegalStateException("Image stream missing");
        }
        String[] image = this.strimziBuilder.imageStream().get().split(":", 2);
        ImageStream is = ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(image[0])).endMetadata()).withNewSpec().withNewLookupPolicy(Boolean.valueOf(true))).endSpec()).build();
        ((NonNamespaceOperation)this.ocp.imageStreams().inNamespace(this.project)).createOrReplace((Object[])new ImageStream[]{is});
    }

    private NonNamespaceOperation<KafkaConnect, KafkaConnectList, Resource<KafkaConnect>> kafkaConnectOperation() {
        return (NonNamespaceOperation)Crds.kafkaConnectOperation((KubernetesClient)this.ocp).inNamespace(this.project);
    }

    public static class Builder
    implements Deployer.Builder<Builder, OcpKafkaConnectDeployer> {
        private String project;
        private OpenShiftClient ocpClient;
        private OkHttpClient httpClient;
        private ConfigMap configMap;
        private StrimziOperatorController operatorController;
        private final StrimziKafkaConnectBuilder strimziBuilder;

        public Builder(StrimziKafkaConnectBuilder strimziBuilder) {
            this.strimziBuilder = strimziBuilder;
        }

        public Builder withProject(String project) {
            this.project = project;
            return this;
        }

        public Builder withOcpClient(OpenShiftClient ocpClient) {
            this.ocpClient = ocpClient;
            return this;
        }

        public Builder withHttpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder withLoggingAndMetricsFromCfgMap(String cfgYamlPath) {
            this.configMap = YAML.fromResource(cfgYamlPath, ConfigMap.class);
            this.strimziBuilder.withLoggingFromConfigMap(this.configMap).withMetricsFromConfigMap(this.configMap);
            return this;
        }

        public Builder withConnectorResources(boolean connectorResources) {
            if (connectorResources) {
                this.strimziBuilder.withConnectorResources();
            }
            return this;
        }

        public Builder withOperatorController(StrimziOperatorController operatorController) {
            this.operatorController = operatorController;
            operatorController.getPullSecretName().ifPresent(this.strimziBuilder::withPullSecret);
            return this;
        }

        @Override
        public OcpKafkaConnectDeployer build() {
            return new OcpKafkaConnectDeployer(this.project, this.strimziBuilder, this.configMap, this.operatorController, this.ocpClient, this.httpClient);
        }

        public Builder withKcBuild(boolean kcBuild) {
            if (kcBuild) {
                this.strimziBuilder.withBuild().withStandardPlugins();
            } else {
                this.strimziBuilder.withImage(ConfigProperties.STRIMZI_KC_IMAGE);
            }
            return this;
        }
    }
}

