/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases;

import io.debezium.testing.system.tools.Deployer;
import io.debezium.testing.system.tools.OpenShiftUtils;
import io.debezium.testing.system.tools.YAML;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOcpDatabaseDeployer<T>
implements Deployer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOcpDatabaseDeployer.class);
    private final OpenShiftClient ocp;
    private final OpenShiftUtils ocpUtils;
    private final String project;
    private final Secret pullSecret;
    private Deployment deployment;
    private List<Service> services;

    public AbstractOcpDatabaseDeployer(String project, Deployment deployment, List<Service> services, Secret pullSecret, OpenShiftClient ocp) {
        this.ocp = ocp;
        this.ocpUtils = new OpenShiftUtils(ocp);
        this.project = project;
        this.deployment = deployment;
        this.services = services;
        this.pullSecret = pullSecret;
    }

    public AbstractOcpDatabaseDeployer(String project, Deployment deployment, List<Service> services, OpenShiftClient ocp) {
        this(project, deployment, services, null, ocp);
    }

    @Override
    public T deploy() {
        LOGGER.info("Deploying pull secrets");
        if (this.pullSecret != null) {
            ((NonNamespaceOperation)this.ocp.secrets().inNamespace(this.project)).createOrReplace((Object[])new Secret[]{this.pullSecret});
            this.ocpUtils.linkPullSecret(this.project, "default", this.pullSecret);
        }
        LOGGER.info("Deploying database");
        this.deployment = (Deployment)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).createOrReplace((Object[])new Deployment[]{this.deployment});
        this.ocpUtils.waitForPods(this.project, this.deployment.getMetadata().getLabels());
        List svcs = this.services.stream().map(s -> (Service)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).createOrReplace((Object[])new Service[]{s})).collect(Collectors.toList());
        LOGGER.info("Database deployed successfully");
        this.services = svcs;
        return this.getController(this.deployment, this.services, this.ocp);
    }

    protected abstract T getController(Deployment var1, List<Service> var2, OpenShiftClient var3);

    public static abstract class DatabaseBuilder<B extends DatabaseBuilder<B, D>, D extends AbstractOcpDatabaseDeployer<?>>
    implements Deployer.Builder<B, D> {
        protected String project;
        protected Deployment deployment;
        protected List<Service> services;
        protected OpenShiftClient ocpClient;
        protected Secret pullSecret;

        public B withProject(String project) {
            this.project = project;
            return (B)((DatabaseBuilder)this.self());
        }

        public B withOcpClient(OpenShiftClient ocpClient) {
            this.ocpClient = ocpClient;
            return (B)((DatabaseBuilder)this.self());
        }

        public B withDeployment(String yamlPath) {
            this.deployment = YAML.fromResource(yamlPath, Deployment.class);
            return (B)((DatabaseBuilder)this.self());
        }

        public B withServices(String ... yamlPath) {
            List<Service> services = Arrays.stream(yamlPath).map(p -> YAML.fromResource(p, Service.class)).collect(Collectors.toList());
            return this.withServices(services);
        }

        public B withServices(Collection<Service> services) {
            this.services = new ArrayList<Service>(services);
            return (B)((DatabaseBuilder)this.self());
        }

        public B withPullSecrets(String yamlPath) {
            this.pullSecret = YAML.from(yamlPath, Secret.class);
            return (B)((DatabaseBuilder)this.self());
        }
    }
}

