/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools;

import io.debezium.testing.system.tools.WaitConditions;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicy;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyFluent;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenShiftUtils.class);
    private OpenShiftClient client;

    public OpenShiftUtils(OpenShiftClient client) {
        this.client = client;
    }

    public Route createRoute(String project, String name, String service, String port, Map<String, String> labels) {
        return (Route)((NonNamespaceOperation)this.client.routes().inNamespace(project)).createOrReplace((Object[])new Route[]{((RouteBuilder)((RouteFluent.SpecNested)((RouteSpecFluent.PortNested)((RouteFluent.SpecNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteBuilder)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)new RouteBuilder().withNewMetadata().withName(name)).withLabels(labels)).endMetadata()).withNewSpec().withNewTo().withKind("Service")).withName(service)).endTo()).withNewPort().withNewTargetPort(port)).endPort()).endSpec()).build()});
    }

    public Service createService(String project, String name, String portName, int port, Map<String, String> selector, Map<String, String> labels) {
        return (Service)((NonNamespaceOperation)this.client.services().inNamespace(project)).createOrReplace((Object[])new Service[]{((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(name)).withLabels(labels)).endMetadata()).withNewSpec().addNewPort().withProtocol("TCP")).withName(portName)).withPort(Integer.valueOf(port))).withTargetPort(new IntOrString(Integer.valueOf(port)))).endPort()).withSelector(selector)).endSpec()).build()});
    }

    public NetworkPolicy createNetworkPolicy(String project, String name, Map<String, String> podSelectorLabels, List<NetworkPolicyPort> ports) {
        NetworkPolicy policy = (NetworkPolicy)((NonNamespaceOperation)this.client.network().networkPolicies().inNamespace(project)).createOrReplace((Object[])new NetworkPolicy[]{((NetworkPolicyBuilder)((NetworkPolicyFluent.SpecNested)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.IngressNested)((NetworkPolicyFluent.SpecNested)((NetworkPolicySpecFluent.PodSelectorNested)((NetworkPolicyBuilder)((NetworkPolicyFluent.MetadataNested)new NetworkPolicyBuilder().withNewMetadata().withName(name)).endMetadata()).withNewSpec().withNewPodSelector().withMatchLabels(podSelectorLabels)).endPodSelector()).addNewIngress().addToPorts(ports.toArray(new NetworkPolicyPort[0]))).endIngress()).withPolicyTypes(new String[]{"Ingress"})).endSpec()).build()});
        return policy;
    }

    public ServiceAccount linkPullSecret(String project, String account, String secret) {
        return (ServiceAccount)((Resource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(project)).withName(account)).edit(sa -> ((ServiceAccountBuilder)((ServiceAccountFluent.SecretsNested)((ServiceAccountBuilder)((ServiceAccountBuilder)((ServiceAccountBuilder)new ServiceAccountBuilder(sa).removeFromImagePullSecrets(new LocalObjectReference[]{new LocalObjectReference(secret)})).addNewImagePullSecret(secret)).removeMatchingFromSecrets(r -> r.getName().equals(secret))).addNewSecret().withName(secret)).endSecret()).build());
    }

    public ServiceAccount linkPullSecret(String project, String account, Secret secret) {
        return this.linkPullSecret(project, account, secret.getMetadata().getName());
    }

    public void ensureHasEnv(Deployment deployment, EnvVar envVar) {
        deployment.getSpec().getTemplate().getSpec().getContainers().forEach(c -> this.ensureHasEnv((Container)c, envVar));
    }

    public void ensureNoEnv(Deployment deployment, String envVar) {
        deployment.getSpec().getTemplate().getSpec().getContainers().forEach(c -> this.ensureNoEnv((Container)c, envVar));
    }

    public void ensureHasEnv(Container container, EnvVar envVar) {
        ArrayList<EnvVar> env = container.getEnv();
        if (env == null) {
            env = new ArrayList<EnvVar>();
            container.setEnv(env);
        }
        env.removeIf(var -> Objects.equals(var.getName(), envVar.getName()));
        env.add(envVar);
    }

    public void ensureNoEnv(Container container, String envVar) {
        List env = container.getEnv();
        if (env == null) {
            return;
        }
        env.removeIf(var -> Objects.equals(var.getName(), envVar));
    }

    public void ensureHasPullSecret(Deployment deployment, String secret) {
        LOGGER.info("Using " + secret + " as image pull secret for deployment '" + deployment.getMetadata().getName() + "'");
        ArrayList<LocalObjectReference> secrets = deployment.getSpec().getTemplate().getSpec().getImagePullSecrets();
        if (secrets == null) {
            secrets = new ArrayList<LocalObjectReference>();
            deployment.getSpec().getTemplate().getSpec().setImagePullSecrets(secrets);
        }
        secrets.removeIf(s -> Objects.equals(secret, s.getName()));
        secrets.add(new LocalObjectReference(secret));
    }

    public PodList podsWithLabels(String project, Map<String, String> labels) {
        Supplier<PodList> podListSupplier = () -> (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(project)).withLabels(labels)).list();
        Awaitility.await().atMost(WaitConditions.scaled(5L), TimeUnit.MINUTES).until(() -> ((PodList)podListSupplier.get()).getItems().size() > 0);
        PodList pods = podListSupplier.get();
        if (pods.getItems().isEmpty()) {
            LOGGER.warn("Empty PodList");
        }
        return pods;
    }

    public void waitForPods(String project, Map<String, String> labels) {
        String lbls = labels.keySet().stream().map(k -> k + "=" + (String)labels.get(k)).collect(Collectors.joining(", "));
        LOGGER.info("Waiting for pods to deploy [" + lbls + "]");
        PodList pods = this.podsWithLabels(project, labels);
        for (Pod p : pods.getItems()) {
            this.client.resource((HasMetadata)p).waitUntilReady(WaitConditions.scaled(5L), TimeUnit.MINUTES);
        }
    }
}

