/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.registry;

import io.apicurio.registry.operator.api.model.ApicurioRegistry;
import io.apicurio.registry.operator.api.model.ApicurioRegistryList;
import io.debezium.testing.system.tools.AbstractOcpDeployer;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.Deployer;
import io.debezium.testing.system.tools.YAML;
import io.debezium.testing.system.tools.registry.RegistryController;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.model.annotation.Version;
import io.fabric8.openshift.client.OpenShiftClient;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOcpApicurioDeployer<C extends RegistryController>
extends AbstractOcpDeployer<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOcpApicurioDeployer.class);
    protected final String yamlPath;
    protected ApicurioRegistry registry;

    public AbstractOcpApicurioDeployer(String project, String yamlPath, OpenShiftClient ocp, OkHttpClient http) {
        super(project, ocp, http);
        this.yamlPath = yamlPath;
    }

    @Override
    public C deploy() throws InterruptedException {
        LOGGER.info("Deploying Apicurio Registry from " + this.yamlPath);
        ApicurioRegistry registry = YAML.fromResource(this.yamlPath, ApicurioRegistry.class);
        registry = (ApicurioRegistry)this.registryOperation().createOrReplace((Object[])new ApicurioRegistry[]{registry});
        C controller = this.getController(registry);
        controller.waitForRegistry();
        return controller;
    }

    protected abstract C getController(ApicurioRegistry var1);

    protected abstract NonNamespaceOperation<ApicurioRegistry, ApicurioRegistryList, Resource<ApicurioRegistry>> registryOperation();

    static {
        Version version = ApicurioRegistry.class.getAnnotation(Version.class);
        if (version == null || !ConfigProperties.APICURIO_CRD_VERSION.equalsIgnoreCase(version.value())) {
            throw new IllegalStateException("Incompatible Apicurio model version");
        }
    }

    public static abstract class RegistryBuilder<B extends RegistryBuilder<B, D>, D extends AbstractOcpApicurioDeployer<?>>
    implements Deployer.Builder<B, D> {
        protected String project;
        protected OpenShiftClient ocpClient;
        protected OkHttpClient httpClient;
        protected String yamlPath;

        public B withProject(String project) {
            this.project = project;
            return (B)((RegistryBuilder)this.self());
        }

        public B withOcpClient(OpenShiftClient ocpClient) {
            this.ocpClient = ocpClient;
            return (B)((RegistryBuilder)this.self());
        }

        public B withHttpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return (B)((RegistryBuilder)this.self());
        }

        public B withYamlPath(String yamlPath) {
            this.yamlPath = yamlPath;
            return (B)((RegistryBuilder)this.self());
        }
    }
}

