/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.mongodb;

import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.databases.AbstractOcpDatabaseController;
import io.debezium.testing.system.tools.databases.DatabaseInitListener;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseClient;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseController;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpMongoController
extends AbstractOcpDatabaseController<MongoDatabaseClient>
implements MongoDatabaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpMongoController.class);
    private static final String DB_INIT_SCRIPT_PATH_CONTAINER = "/usr/local/bin/init-inventory.sh";

    public OcpMongoController(Deployment deployment, List<Service> services, OpenShiftClient ocp) {
        super(deployment, services, ocp);
    }

    @Override
    public String getPublicDatabaseUrl() {
        return "mongodb://" + this.getPublicDatabaseHostname() + ":" + this.getPublicDatabasePort();
    }

    @Override
    public void initialize() throws InterruptedException {
        Pod pod = (Pod)((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withLabel("deployment", this.name)).list()).getItems().get(0);
        String svcName = this.deployment.getMetadata().getName();
        CountDownLatch latch = new CountDownLatch(1);
        try (ExecWatch exec = (ExecWatch)((Execable)((TtyExecErrorChannelable)((TtyExecErrorable)((ContainerResource)((PodResource)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withName(pod.getMetadata().getName())).inContainer((Object)"mongo")).writingOutput((Object)System.out)).writingError((Object)System.err)).usingListener((Object)new DatabaseInitListener("mongo", latch))).exec((Object[])new String[]{"bash", "-c", "/usr/local/bin/init-inventory.sh -h " + svcName + "." + this.project + ".svc.cluster.local"});){
            LOGGER.info("Waiting until database is initialized");
            latch.await(WaitConditions.scaled(1L), TimeUnit.MINUTES);
        }
    }

    @Override
    public MongoDatabaseClient getDatabaseClient(String username, String password) {
        return this.getDatabaseClient(username, password, "admin");
    }

    @Override
    public MongoDatabaseClient getDatabaseClient(String username, String password, String authSource) {
        return new MongoDatabaseClient(this.getPublicDatabaseUrl(), username, password, authSource);
    }
}

