/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.registry;

import io.apicurio.registry.operator.api.model.ApicurioRegistry;
import io.apicurio.registry.operator.api.model.ApicurioRegistryList;
import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.registry.AbstractOcpApicurioController;
import io.debezium.testing.system.tools.registry.RegistryController;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpApicurioV2Controller
extends AbstractOcpApicurioController
implements RegistryController {
    public static final String APICURIO_CRD_DESCRIPTOR = "/crd/v1/apicurioregistries_crd.yaml";
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpApicurioV2Controller.class);

    public OcpApicurioV2Controller(ApicurioRegistry registry, OpenShiftClient ocp, OkHttpClient http) {
        super(registry, ocp, http);
    }

    @Override
    protected NonNamespaceOperation<ApicurioRegistry, ApicurioRegistryList, Resource<ApicurioRegistry>> registryOperation() {
        CustomResourceDefinition crd = (CustomResourceDefinition)((Resource)this.ocp.apiextensions().v1().customResourceDefinitions().load(OcpApicurioV2Controller.class.getResourceAsStream(APICURIO_CRD_DESCRIPTOR))).get();
        CustomResourceDefinitionContext context = CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)crd);
        return (NonNamespaceOperation)this.ocp.customResources((ResourceDefinitionContext)context, ApicurioRegistry.class, ApicurioRegistryList.class).inNamespace(this.project);
    }

    @Override
    public String getRegistryApiAddress() {
        return this.getRegistryAddress() + "/apis/registry/v2";
    }

    @Override
    public String getPublicRegistryApiAddress() {
        return "http://" + this.getPublicRegistryAddress() + "/apis/registry/v2";
    }

    @Override
    public void waitForRegistry() throws InterruptedException {
        LOGGER.info("Waiting for deployments of registry '" + this.name + "'");
        Awaitility.await().atMost(WaitConditions.scaled(1L), TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(() -> !this.getRegistryDeployments(this.name).isEmpty());
        Deployment deployment = this.getRegistryDeployments(this.name).get(0);
        ((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName(deployment.getMetadata().getName())).waitUntilCondition(WaitConditions::deploymentAvailableCondition, WaitConditions.scaled(5L), TimeUnit.MINUTES);
        this.registry = (ApicurioRegistry)((Resource)this.registryOperation().withName(this.name)).get();
    }

    private List<Deployment> getRegistryDeployments(String name) {
        return ((DeploymentList)((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withLabel("app", name)).list()).getItems();
    }
}

