/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.registry;

import io.apicurio.registry.operator.api.model.ApicurioRegistry;
import io.apicurio.registry.operator.api.model.ApicurioRegistryList;
import io.debezium.testing.system.tools.kafka.KafkaController;
import io.debezium.testing.system.tools.kafka.OcpKafkaController;
import io.debezium.testing.system.tools.registry.AbstractOcpApicurioDeployer;
import io.debezium.testing.system.tools.registry.OcpApicurioV1Controller;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.openshift.client.OpenShiftClient;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpApicurioV1Deployer
extends AbstractOcpApicurioDeployer<OcpApicurioV1Controller> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpApicurioV1Deployer.class);
    public static final String APICURIO_CRD_DESCRIPTOR = "/crd/v1beta1/apicurioregistries_crd.yaml";
    private final KafkaController kafkaController;
    private final String idTopicYamlPath;
    private final String storageTopicYamlPath;

    private OcpApicurioV1Deployer(String project, String yamlPath, String storageTopicYamlPath, String idTopicYamlPath, KafkaController kafkaController, OpenShiftClient ocp, OkHttpClient http) {
        super(project, yamlPath, ocp, http);
        this.kafkaController = kafkaController;
        this.storageTopicYamlPath = storageTopicYamlPath;
        this.idTopicYamlPath = idTopicYamlPath;
    }

    @Override
    public OcpApicurioV1Controller deploy() throws InterruptedException {
        LOGGER.info("Deploying kafka topics from  " + this.storageTopicYamlPath + ", " + this.idTopicYamlPath);
        ((OcpKafkaController)this.kafkaController).deployTopic(this.storageTopicYamlPath);
        ((OcpKafkaController)this.kafkaController).deployTopic(this.idTopicYamlPath);
        return (OcpApicurioV1Controller)super.deploy();
    }

    @Override
    protected OcpApicurioV1Controller getController(ApicurioRegistry registry) {
        return new OcpApicurioV1Controller(registry, this.ocp, this.http);
    }

    @Override
    protected NonNamespaceOperation<ApicurioRegistry, ApicurioRegistryList, Resource<ApicurioRegistry>> registryOperation() {
        CustomResourceDefinition crd = (CustomResourceDefinition)((Resource)this.ocp.apiextensions().v1beta1().customResourceDefinitions().load(OcpApicurioV1Deployer.class.getResourceAsStream(APICURIO_CRD_DESCRIPTOR))).get();
        CustomResourceDefinitionContext context = CustomResourceDefinitionContext.fromCrd((CustomResourceDefinition)crd);
        return (NonNamespaceOperation)this.ocp.customResources((ResourceDefinitionContext)context, ApicurioRegistry.class, ApicurioRegistryList.class).inNamespace(this.project);
    }

    public static class Builder
    extends AbstractOcpApicurioDeployer.RegistryBuilder<Builder, OcpApicurioV1Deployer> {
        private String storageTopicYamlPath;
        private String idTopicYamlPath;
        private KafkaController kafkaController;

        public Builder withTopicsYamlPath(String storageTopicYamlPath, String idTopicYamlPath) {
            this.storageTopicYamlPath = storageTopicYamlPath;
            this.idTopicYamlPath = idTopicYamlPath;
            return (Builder)this.self();
        }

        public Builder withKafkaController(KafkaController kafkaController) {
            this.kafkaController = kafkaController;
            return (Builder)this.self();
        }

        @Override
        public OcpApicurioV1Deployer build() {
            return new OcpApicurioV1Deployer(this.project, this.yamlPath, this.storageTopicYamlPath, this.idTopicYamlPath, this.kafkaController, this.ocpClient, this.httpClient);
        }
    }
}

