/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka.connectors;

import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.kafka.connectors.ConnectorMetricsReader;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestPrometheusMetricReader
implements ConnectorMetricsReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestPrometheusMetricReader.class);
    private final HttpUrl url;

    public RestPrometheusMetricReader(HttpUrl url) {
        this.url = url;
    }

    public List<String> getMetrics() {
        List<String> list;
        block8: {
            LOGGER.info("Retrieving connector metrics");
            OkHttpClient httpClient = new OkHttpClient();
            Request r = new Request.Builder().url(this.url).get().build();
            Response res = httpClient.newCall(r).execute();
            try {
                String metrics = res.body().string();
                list = Stream.of(metrics.split("\\r?\\n")).collect(Collectors.toList());
                if (res == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            res.close();
        }
        return list;
    }

    public void waitForSnapshot(String connectorName, String metricName) {
        LOGGER.info("Waiting for connector '" + connectorName + "' to finish snapshot");
        Awaitility.await().atMost(WaitConditions.scaled(5L), TimeUnit.MINUTES).pollInterval(10L, TimeUnit.SECONDS).until(() -> this.getMetrics().stream().anyMatch(s -> s.contains(metricName) && s.contains(connectorName)));
    }

    @Override
    public void waitForMySqlSnapshot(String connectorName) {
        this.waitForSnapshot(connectorName, "debezium_mysql_connector_metrics_snapshotcompleted");
    }

    @Override
    public void waitForPostgreSqlSnapshot(String connectorName) {
        this.waitForSnapshot(connectorName, "debezium_postgres_connector_metrics_snapshotcompleted");
    }

    @Override
    public void waitForSqlServerSnapshot(String connectorName) {
        this.waitForSnapshot(connectorName, "debezium_sql_server_connector_metrics_snapshotcompleted");
    }

    @Override
    public void waitForMongoSnapshot(String connectorName) {
        this.waitForSnapshot(connectorName, "debezium_mongodb_connector_metrics_snapshotcompleted");
    }

    @Override
    public void waitForDB2Snapshot(String connectorName) {
        this.waitForSnapshot(connectorName, "debezium_db2_server_connector_metrics_snapshotcompleted");
    }
}

