/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools;

import io.debezium.testing.system.tools.OpenShiftUtils;
import io.debezium.testing.system.tools.WaitConditions;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperatorController.class);
    protected final OpenShiftClient ocp;
    protected final OpenShiftUtils ocpUtils;
    protected final Map<String, String> podLabels;
    protected String project;
    protected Deployment operator;
    protected String name;

    public OperatorController(Deployment operator, Map<String, String> podLabels, OpenShiftClient ocp) {
        this.operator = operator;
        this.podLabels = podLabels;
        this.name = operator.getMetadata().getName();
        this.project = operator.getMetadata().getNamespace();
        this.ocp = ocp;
        this.ocpUtils = new OpenShiftUtils(ocp);
    }

    public void disable() {
        LOGGER.info("Disabling Operator");
        this.setNumberOfReplicas(0);
        this.operator = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName(this.name)).createOrReplace((Object[])new Deployment[]{this.operator});
        Awaitility.await().atMost(WaitConditions.scaled(30L), TimeUnit.SECONDS).pollDelay(5L, TimeUnit.SECONDS).pollInterval(3L, TimeUnit.SECONDS).until(() -> ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withLabels(this.podLabels)).list()).getItems().isEmpty());
    }

    public void enable() throws InterruptedException {
        LOGGER.info("Enabling Operator");
        this.setNumberOfReplicas(1);
        this.updateOperator();
    }

    public void setNumberOfReplicas(int replicas) {
        LOGGER.info("Scaling Operator replicas to " + replicas);
        this.operator.getSpec().setReplicas(Integer.valueOf(replicas));
    }

    public void setSingleReplica() {
        this.setNumberOfReplicas(1);
    }

    public void setImagePullSecret(String secret) {
        LOGGER.info("Using " + secret + " as image pull secret for deployment '" + this.name + "'");
        List<LocalObjectReference> pullSecrets = Collections.singletonList(new LocalObjectReference(secret));
        this.ocpUtils.ensureHasPullSecret(this.operator, secret);
    }

    public void setAlwaysPullPolicy() {
        LOGGER.info("Using 'Always' pull policy for all containers of deployment " + this.name + "'");
        List containers = this.operator.getSpec().getTemplate().getSpec().getContainers();
        containers.forEach(c -> c.setImagePullPolicy("Always"));
    }

    public void setEnvVar(String name, String val) {
        LOGGER.info("Setting variable " + name + "='" + val + "' on deployment '" + this.name + "'");
        this.ocpUtils.ensureHasEnv(this.operator, new EnvVar(name, val, null));
    }

    public Deployment updateOperator() throws InterruptedException {
        this.operator = (Deployment)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).createOrReplace((Object[])new Deployment[]{this.operator});
        this.operator = this.waitForAvailable();
        return this.operator;
    }

    private Deployment waitForAvailable() throws InterruptedException {
        return (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName(this.name)).waitUntilCondition(WaitConditions::deploymentAvailableCondition, WaitConditions.scaled(5L), TimeUnit.MINUTES);
    }
}

