/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.rocketmq;

import java.util.Objects;

public class RocketMqConfig {
    private String namesrvAddr;
    private String groupId;
    private boolean aclEnable;
    private String accessKey;
    private String secretKey;

    private RocketMqConfig(String rmqConsumerGroup, String namesrvAddr, boolean aclEnable, String accessKey, String secretKey) {
        this.groupId = rmqConsumerGroup;
        this.namesrvAddr = namesrvAddr;
        this.aclEnable = aclEnable;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean isAclEnable() {
        return this.aclEnable;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RocketMqConfig that = (RocketMqConfig)o;
        return this.aclEnable == that.aclEnable && Objects.equals(this.namesrvAddr, that.namesrvAddr) && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.accessKey, that.accessKey) && Objects.equals(this.secretKey, that.secretKey);
    }

    public int hashCode() {
        return Objects.hash(this.namesrvAddr, this.groupId, this.aclEnable, this.accessKey, this.secretKey);
    }

    public String toString() {
        return "RocketMqConfig{namesrvAddr='" + this.namesrvAddr + "', groupId='" + this.groupId + "', aclEnable=" + this.aclEnable + ", accessKey='" + this.accessKey + "', secretKey='" + this.secretKey + "'}";
    }

    public static class Builder {
        private String namesrvAddr;
        private String groupId;
        private boolean aclEnable;
        private String accessKey;
        private String secretKey;

        public Builder namesrvAddr(String namesrvAddr) {
            this.namesrvAddr = namesrvAddr;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder aclEnable(boolean aclEnable) {
            this.aclEnable = aclEnable;
            return this;
        }

        public Builder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public RocketMqConfig build() {
            return new RocketMqConfig(this.groupId, this.namesrvAddr, this.aclEnable, this.accessKey, this.secretKey);
        }
    }
}

