/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.rocketmq;

import io.debezium.DebeziumException;
import io.debezium.storage.rocketmq.RocketMqConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.DefaultLitePullConsumer;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.admin.TopicOffset;
import org.apache.rocketmq.common.admin.TopicStatsTable;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.body.ClusterInfo;
import org.apache.rocketmq.common.protocol.body.SubscriptionGroupWrapper;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.common.protocol.route.TopicRouteData;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.protocol.LanguageCode;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.admin.MQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;

public class RocketMqAdminUtil {
    public static String createUniqInstance(String prefix) {
        return prefix.concat("-").concat(UUID.randomUUID().toString());
    }

    public static RPCHook getAclRPCHook(String accessKey, String secretKey) {
        return new AclClientRPCHook(new SessionCredentials(accessKey, secretKey));
    }

    public static DefaultLitePullConsumer initDefaultLitePullConsumer(RocketMqConfig config, boolean autoCommit) throws MQClientException {
        DefaultLitePullConsumer consumer = null;
        if (Objects.isNull(consumer)) {
            consumer = StringUtils.isBlank((CharSequence)config.getAccessKey()) && StringUtils.isBlank((CharSequence)config.getSecretKey()) ? new DefaultLitePullConsumer(config.getGroupId()) : new DefaultLitePullConsumer(config.getGroupId(), RocketMqAdminUtil.getAclRPCHook(config.getAccessKey(), config.getSecretKey()));
        }
        consumer.setNamesrvAddr(config.getNamesrvAddr());
        String uniqueName = RocketMqAdminUtil.createUniqInstance(config.getNamesrvAddr());
        consumer.setInstanceName(uniqueName);
        consumer.setUnitName(uniqueName);
        consumer.setAutoCommit(autoCommit);
        consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
        return consumer;
    }

    public static DefaultMQProducer initDefaultMqProducer(RocketMqConfig connectConfig) {
        AclClientRPCHook rpcHook = null;
        if (connectConfig.isAclEnable()) {
            rpcHook = new AclClientRPCHook(new SessionCredentials(connectConfig.getAccessKey(), connectConfig.getSecretKey()));
        }
        DefaultMQProducer producer = new DefaultMQProducer(rpcHook);
        producer.setNamesrvAddr(connectConfig.getNamesrvAddr());
        producer.setInstanceName(RocketMqAdminUtil.createUniqInstance(connectConfig.getNamesrvAddr()));
        producer.setProducerGroup(connectConfig.getGroupId());
        producer.setLanguage(LanguageCode.JAVA);
        return producer;
    }

    private static DefaultMQAdminExt startMqAdminTool(RocketMqConfig config) throws MQClientException {
        DefaultMQAdminExt admin = config.isAclEnable() ? new DefaultMQAdminExt((RPCHook)new AclClientRPCHook(new SessionCredentials(config.getAccessKey(), config.getSecretKey()))) : new DefaultMQAdminExt();
        admin.setNamesrvAddr(config.getNamesrvAddr());
        admin.setAdminExtGroup(config.getGroupId());
        admin.setInstanceName(RocketMqAdminUtil.createUniqInstance(config.getNamesrvAddr()));
        admin.start();
        return admin;
    }

    public static void createTopic(RocketMqConfig config, TopicConfig topicConfig) {
        DefaultMQAdminExt defaultMQAdminExt = null;
        try {
            defaultMQAdminExt = RocketMqAdminUtil.startMqAdminTool(config);
            ClusterInfo clusterInfo = defaultMQAdminExt.examineBrokerClusterInfo();
            HashMap clusterAddrTable = clusterInfo.getClusterAddrTable();
            Set clusterNameSet = clusterAddrTable.keySet();
            for (String clusterName : clusterNameSet) {
                Set masterSet = CommandUtil.fetchMasterAddrByClusterName((MQAdminExt)defaultMQAdminExt, (String)clusterName);
                for (String addr : masterSet) {
                    defaultMQAdminExt.createAndUpdateTopicConfig(addr, topicConfig);
                }
            }
        }
        catch (Exception e) {
            throw new DebeziumException("RocketMQ create schema history topic: " + topicConfig.getTopicName() + "  failed", (Throwable)e);
        }
        finally {
            if (defaultMQAdminExt != null) {
                defaultMQAdminExt.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean topicExist(RocketMqConfig config, String topic) {
        boolean foundTopicRouteInfo;
        block9: {
            DefaultMQAdminExt defaultMQAdminExt = null;
            foundTopicRouteInfo = false;
            try {
                defaultMQAdminExt = RocketMqAdminUtil.startMqAdminTool(config);
                TopicRouteData topicRouteData = defaultMQAdminExt.examineTopicRouteInfo(topic);
                if (topicRouteData != null) {
                    foundTopicRouteInfo = true;
                }
            }
            catch (Exception e) {
                if (e instanceof MQClientException) {
                    if (((MQClientException)e).getResponseCode() == 17) {
                        foundTopicRouteInfo = false;
                        break block9;
                    }
                    throw new RuntimeException("Failed to get topic information", e);
                }
                throw new RuntimeException("Failed to get topic information", e);
            }
            finally {
                if (defaultMQAdminExt != null) {
                    defaultMQAdminExt.shutdown();
                }
            }
        }
        return foundTopicRouteInfo;
    }

    public static Set<String> fetchAllConsumerGroup(RocketMqConfig connectConfig) {
        HashSet<String> consumerGroupSet = new HashSet<String>();
        DefaultMQAdminExt defaultMQAdminExt = null;
        try {
            defaultMQAdminExt = RocketMqAdminUtil.startMqAdminTool(connectConfig);
            ClusterInfo clusterInfo = defaultMQAdminExt.examineBrokerClusterInfo();
            for (BrokerData brokerData : clusterInfo.getBrokerAddrTable().values()) {
                SubscriptionGroupWrapper subscriptionGroupWrapper = defaultMQAdminExt.getAllSubscriptionGroup(brokerData.selectBrokerAddr(), 3000L);
                consumerGroupSet.addAll(subscriptionGroupWrapper.getSubscriptionGroupTable().keySet());
            }
        }
        catch (Exception e) {
            throw new DebeziumException("RocketMQ admin fetch all topic failed", (Throwable)e);
        }
        finally {
            if (defaultMQAdminExt != null) {
                defaultMQAdminExt.shutdown();
            }
        }
        return consumerGroupSet;
    }

    public static String createGroup(RocketMqConfig connectConfig, String group) {
        DefaultMQAdminExt defaultMQAdminExt = null;
        try {
            defaultMQAdminExt = RocketMqAdminUtil.startMqAdminTool(connectConfig);
            SubscriptionGroupConfig initConfig = new SubscriptionGroupConfig();
            initConfig.setGroupName(group);
            ClusterInfo clusterInfo = defaultMQAdminExt.examineBrokerClusterInfo();
            HashMap clusterAddrTable = clusterInfo.getClusterAddrTable();
            Set clusterNameSet = clusterAddrTable.keySet();
            for (String clusterName : clusterNameSet) {
                Set masterSet = CommandUtil.fetchMasterAddrByClusterName((MQAdminExt)defaultMQAdminExt, (String)clusterName);
                for (String addr : masterSet) {
                    defaultMQAdminExt.createAndUpdateSubscriptionGroupConfig(addr, initConfig);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("create subGroup: " + group + " failed", e);
        }
        finally {
            if (defaultMQAdminExt != null) {
                defaultMQAdminExt.shutdown();
            }
        }
        return group;
    }

    public static Map<MessageQueue, TopicOffset> offsets(RocketMqConfig config, String topic) {
        DefaultMQAdminExt adminClient = null;
        try {
            adminClient = RocketMqAdminUtil.startMqAdminTool(config);
            TopicStatsTable topicStatsTable = adminClient.examineTopicStats(topic);
            HashMap hashMap = topicStatsTable.getOffsetTable();
            return hashMap;
        }
        catch (InterruptedException | MQBrokerException | MQClientException | RemotingException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (adminClient != null) {
                adminClient.shutdown();
            }
        }
    }
}

