/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.redis;

import io.debezium.DebeziumException;
import io.debezium.storage.redis.JedisClient;
import io.debezium.storage.redis.JedisClusterClient;
import io.debezium.storage.redis.RedisClient;
import io.debezium.storage.redis.RedisClientConnectionException;
import io.debezium.storage.redis.RedisCommonConfig;
import io.debezium.storage.redis.WaitReplicasRedisClient;
import io.debezium.util.Strings;
import java.io.File;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.SslOptions;
import redis.clients.jedis.SslVerifyMode;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;

public class RedisConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisConnection.class);
    public static final String DEBEZIUM_OFFSETS_CLIENT_NAME = "debezium:offsets";
    public static final String DEBEZIUM_SCHEMA_HISTORY = "debezium:schema_history";
    private static final String HOST_PORT_ERROR = "Invalid host:port format in '<...>.redis.address' property.";
    private final String address;
    private final int dbIndex;
    private final String user;
    private final String password;
    private final int connectionTimeout;
    private final int socketTimeout;
    private final boolean sslEnabled;
    private final boolean hostnameVerificationEnabled;
    private final boolean clusterEnabled;
    private final String truststorePath;
    private final String truststorePassword;
    private final String truststoreType;
    private final String keystorePath;
    private final String keystorePassword;
    private final String keystoreType;

    public RedisConnection(String address, int dbIndex, String user, String password, int connectionTimeout, int socketTimeout, boolean sslEnabled) {
        this(address, dbIndex, user, password, connectionTimeout, socketTimeout, sslEnabled, false);
    }

    public RedisConnection(String address, int dbIndex, String user, String password, int connectionTimeout, int socketTimeout, boolean sslEnabled, boolean hostnameVerificationEnabled) {
        this(address, dbIndex, user, password, connectionTimeout, socketTimeout, sslEnabled, hostnameVerificationEnabled, null, null, null, null, null, null);
    }

    public RedisConnection(String address, int dbIndex, String user, String password, int connectionTimeout, int socketTimeout, boolean sslEnabled, boolean hostnameVerificationEnabled, String truststorePath, String truststorePassword, String truststoreType, String keystorePath, String keystorePassword, String keystoreType) {
        this(address, dbIndex, user, password, connectionTimeout, socketTimeout, sslEnabled, hostnameVerificationEnabled, truststorePath, truststorePassword, truststoreType, keystorePath, keystorePassword, keystoreType, false);
    }

    public RedisConnection(String address, int dbIndex, String user, String password, int connectionTimeout, int socketTimeout, boolean sslEnabled, boolean hostnameVerificationEnabled, String truststorePath, String truststorePassword, String truststoreType, String keystorePath, String keystorePassword, String keystoreType, boolean clusterEnabled) {
        this.validateHostPort(address);
        this.address = address;
        this.dbIndex = dbIndex;
        this.user = user;
        this.password = password;
        this.connectionTimeout = connectionTimeout;
        this.socketTimeout = socketTimeout;
        this.sslEnabled = sslEnabled;
        this.hostnameVerificationEnabled = hostnameVerificationEnabled;
        this.clusterEnabled = clusterEnabled;
        this.truststorePath = truststorePath;
        this.truststorePassword = truststorePassword;
        this.truststoreType = truststoreType;
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
        this.keystoreType = keystoreType;
    }

    public static RedisConnection getInstance(RedisCommonConfig config) {
        return new RedisConnection(config.getAddress(), config.getDbIndex(), config.getUser(), config.getPassword(), config.getConnectionTimeout(), config.getSocketTimeout(), config.isSslEnabled(), config.isHostnameVerificationEnabled(), config.getTruststorePath(), config.getTruststorePassword(), config.getTruststoreType(), config.getKeystorePath(), config.getKeystorePassword(), config.getKeystoreType(), config.isClusterEnabled());
    }

    public RedisClient getRedisClient(String clientName, boolean waitEnabled, long waitTimeout, boolean waitRetry, long waitRetryDelay) {
        if (waitEnabled && waitTimeout <= 0L) {
            throw new DebeziumException("Redis client wait timeout should be positive");
        }
        boolean isCluster = this.clusterEnabled;
        try {
            boolean configureSslOptions;
            DefaultJedisClientConfig.Builder configBuilder = DefaultJedisClientConfig.builder().database(this.dbIndex).connectionTimeoutMillis(this.connectionTimeout).socketTimeoutMillis(this.socketTimeout).ssl(this.sslEnabled);
            boolean bl = configureSslOptions = this.sslEnabled && (!Strings.isNullOrEmpty((String)this.truststorePath) || !Strings.isNullOrEmpty((String)this.keystorePath));
            if (configureSslOptions) {
                char[] tsPasswordRaw = !Strings.isNullOrEmpty((String)this.truststorePassword) ? this.truststorePassword.toCharArray() : null;
                char[] cArray = !Strings.isNullOrEmpty((String)this.keystorePassword) ? this.keystorePassword.toCharArray() : null;
                SslOptions sslOptions = SslOptions.builder().truststore(new File(this.truststorePath), tsPasswordRaw).trustStoreType(this.truststoreType).keystore(new File(this.keystorePath), cArray).keyStoreType(this.keystoreType).sslVerifyMode(this.hostnameVerificationEnabled ? SslVerifyMode.FULL : SslVerifyMode.CA).build();
                configBuilder.sslOptions(sslOptions);
            } else if (this.hostnameVerificationEnabled) {
                SSLParameters sslParameters = new SSLParameters();
                sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                configBuilder.sslParameters(sslParameters);
            }
            if (!Strings.isNullOrEmpty((String)this.user)) {
                configBuilder = configBuilder.user(this.user);
            }
            if (!Strings.isNullOrEmpty((String)this.password)) {
                configBuilder = configBuilder.password(this.password);
            }
            if (isCluster) {
                HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
                for (String part : this.address.split(",")) {
                    nodes.add(HostAndPort.from((String)part.trim()));
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Redis cluster mode enabled; nodes: {}", nodes);
                }
                JedisCluster jedisCluster = new JedisCluster(nodes, (JedisClientConfig)configBuilder.build());
                jedisCluster.ping();
                JedisClusterClient clusterClient = new JedisClusterClient(jedisCluster);
                LOGGER.info("Using Redis client '{}'", (Object)clusterClient);
                return clusterClient;
            }
            String firstAddress = this.address.split(",")[0].trim();
            if (this.address.contains(",")) {
                LOGGER.warn("Multiple Redis addresses provided but cluster mode disabled; using the first address: {}", (Object)firstAddress);
            }
            HostAndPort hostAndPort = HostAndPort.from((String)firstAddress);
            Jedis client = new Jedis(hostAndPort, (JedisClientConfig)configBuilder.build());
            client.ping();
            try {
                client.clientSetname(clientName);
            }
            catch (JedisDataException e) {
                LOGGER.warn("Failed to set client name", (Throwable)e);
            }
            JedisClient jedisClient = new JedisClient(client);
            RedisClient redisClient = waitEnabled ? new WaitReplicasRedisClient(jedisClient, 1, waitTimeout, waitRetry, waitRetryDelay) : jedisClient;
            LOGGER.info("Using Redis client '{}'", (Object)redisClient);
            return redisClient;
        }
        catch (JedisConnectionException e) {
            throw new RedisClientConnectionException(e);
        }
    }

    private void validateHostPort(String address) {
        String[] parts;
        Pattern pattern = Pattern.compile("^[\\w.-]+:\\d{1,5}+$");
        for (String part : parts = address.split(",")) {
            String trimmed = part.trim();
            if (!trimmed.isEmpty() && pattern.matcher(trimmed).matches()) continue;
            throw new DebeziumException(HOST_PORT_ERROR);
        }
    }
}

