/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.redis;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.util.Collect;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCommonConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisCommonConfig.class);
    public static final String CONFIGURATION_FIELD_PREFIX_STRING = "redis.";
    private static final Field PROP_ADDRESS = Field.create((String)"redis.address").withDescription("The url that will be used to access Redis").required();
    private static final Field PROP_USER = Field.create((String)"redis.user").withDescription("The user that will be used to access Redis");
    private static final Field PROP_PASSWORD = Field.create((String)"redis.password").withDescription("The password that will be used to access Redis");
    private static final int DEFAULT_DB_INDEX = 0;
    private static final Field PROP_DB_INDEX = Field.create((String)"redis.db.index").withDescription("The database index (0..15) that will be used to access Redis").withAllowedValues(IntStream.rangeClosed(0, 15).boxed().collect(Collectors.toSet())).withDefault(0);
    private static final boolean DEFAULT_SSL_ENABLED = false;
    private static final Field PROP_SSL_ENABLED = Field.create((String)"redis.ssl.enabled").withDescription("Use SSL for Redis connection").withDefault(false);
    private static final String DEFAULT_TRUSTSTORE_PATH = "";
    private static final Field PROP_SSL_TRUSTSTORE_PATH = Field.create((String)"redis.ssl.truststore.path").withDescription("Path to the truststore file").withDefault("");
    private static final String DEFAULT_TRUSTSTORE_PASSWORD = "";
    private static final Field PROP_SSL_TRUSTSTORE_PASSWORD = Field.create((String)"redis.ssl.truststore.password").withDescription("Password for the truststore").withDefault("");
    private static final String DEFAULT_TRUSTSTORE_TYPE = "JKS";
    private static final Field PROP_SSL_TRUSTSTORE_TYPE = Field.create((String)"redis.ssl.truststore.type").withDescription("Type of the truststore (e.g., JKS, PKCS12), defaults to JKS").withDefault("JKS");
    private static final String DEFAULT_KEYSTORE_PATH = "";
    private static final Field PROP_SSL_KEYSTORE_PATH = Field.create((String)"redis.ssl.keystore.path").withDescription("Path to the keystore file").withDefault("");
    private static final String DEFAULT_KEYSTORE_PASSWORD = "";
    private static final Field PROP_SSL_KEYSTORE_PASSWORD = Field.create((String)"redis.ssl.keystore.password").withDescription("Password for the keystore").withDefault("");
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static final Field PROP_SSL_KEYSTORE_TYPE = Field.create((String)"redis.ssl.keystore.type").withDescription("Type of the keystore (e.g., JKS, PKCS12), defaults to JKS").withDefault("JKS");
    private static final boolean DEFAULT_HOSTNAME_VERIFICATION = false;
    private static final Field PROP_SSL_HOSTNAME_VERIFICATION_ENABLED = Field.create((String)"redis.ssl.hostname.verification.enabled").withDescription("Enable hostname verification").withDefault(false);
    private static final Integer DEFAULT_CONNECTION_TIMEOUT = 2000;
    private static final Field PROP_CONNECTION_TIMEOUT = Field.create((String)"redis.connection.timeout.ms").withDescription("Connection timeout (in ms)").withDefault(DEFAULT_CONNECTION_TIMEOUT.intValue());
    private static final Integer DEFAULT_SOCKET_TIMEOUT = 2000;
    private static final Field PROP_SOCKET_TIMEOUT = Field.create((String)"redis.socket.timeout.ms").withDescription("Socket timeout (in ms)").withDefault(DEFAULT_SOCKET_TIMEOUT.intValue());
    private static final Integer DEFAULT_RETRY_INITIAL_DELAY = 300;
    private static final Field PROP_RETRY_INITIAL_DELAY = Field.create((String)"redis.retry.initial.delay.ms").withDescription("Initial retry delay (in ms)").withDefault(DEFAULT_RETRY_INITIAL_DELAY.intValue());
    private static final Integer DEFAULT_RETRY_MAX_DELAY = 10000;
    private static final Field PROP_RETRY_MAX_DELAY = Field.create((String)"redis.retry.max.delay.ms").withDescription("Maximum retry delay (in ms)").withDefault(DEFAULT_RETRY_MAX_DELAY.intValue());
    private static final Integer DEFAULT_MAX_RETRIES = 10;
    private static final Field PROP_MAX_RETRIES = Field.create((String)"redis.retry.max.attempts").withDescription("Maximum number of retry attempts before giving up.").withDefault(DEFAULT_MAX_RETRIES.intValue());
    private static final boolean DEFAULT_WAIT_ENABLED = false;
    private static final Field PROP_WAIT_ENABLED = Field.create((String)"redis.wait.enabled").withDescription("Enables wait for replica. In case Redis is configured with a replica shard, this allows to verify that the data has been written to the replica.").withDefault(false);
    private static final long DEFAULT_WAIT_TIMEOUT = 1000L;
    private static final Field PROP_WAIT_TIMEOUT = Field.create((String)"redis.wait.timeout.ms").withDescription("Timeout when wait for replica").withDefault(1000L);
    private static final boolean DEFAULT_WAIT_RETRY_ENABLED = false;
    private static final Field PROP_WAIT_RETRY_ENABLED = Field.create((String)"redis.wait.retry.enabled").withDescription("Enables retry on wait for replica failure").withDefault(false);
    private static final long DEFAULT_WAIT_RETRY_DELAY = 1000L;
    private static final Field PROP_WAIT_RETRY_DELAY = Field.create((String)"redis.wait.retry.delay.ms").withDescription("Delay of retry on wait for replica failure").withDefault(1000L);
    private static final boolean DEFAULT_CLUSTER_ENABLED = false;
    private static final Field PROP_CLUSTER_ENABLED = Field.create((String)"redis.cluster.enabled").withDescription("Enable Redis Cluster mode; when true, a JedisCluster client will be created. Single or comma-separated host:port addresses are accepted.").withDefault(false);
    private String address;
    private int dbIndex;
    private String user;
    private String password;
    private boolean sslEnabled;
    private boolean hostnameVerificationEnabled;
    private String truststorePath;
    private String truststorePassword;
    private String truststoreType;
    private String keystorePath;
    private String keystorePassword;
    private String keystoreType;
    private Integer initialRetryDelay;
    private Integer maxRetryDelay;
    private Integer maxRetryCount;
    private Integer connectionTimeout;
    private Integer socketTimeout;
    private boolean waitEnabled;
    private long waitTimeout;
    private boolean waitRetryEnabled;
    private long waitRetryDelay;
    private boolean clusterEnabled;

    public RedisCommonConfig(Configuration config, String prefix) {
        config = config.subset(prefix, true);
        LOGGER.info("Configuration for '{}' with prefix '{}': {}", new Object[]{this.getClass().getSimpleName(), prefix, config.withMaskedPasswords()});
        if (!config.validateAndRecord(this.getAllConfigurationFields(), error -> LOGGER.error("Validation error for property with prefix '{}': {}", (Object)prefix, error))) {
            throw new DebeziumException(String.format("Error configuring an instance of '%s' with prefix '%s'; check the logs for errors", this.getClass().getSimpleName(), prefix));
        }
        this.init(config);
    }

    protected List<Field> getAllConfigurationFields() {
        return Collect.arrayListOf((Object)PROP_ADDRESS, (Object[])new Field[]{PROP_DB_INDEX, PROP_USER, PROP_PASSWORD, PROP_SSL_ENABLED, PROP_SSL_HOSTNAME_VERIFICATION_ENABLED, PROP_SSL_TRUSTSTORE_PATH, PROP_SSL_TRUSTSTORE_PASSWORD, PROP_SSL_TRUSTSTORE_TYPE, PROP_SSL_KEYSTORE_PATH, PROP_SSL_KEYSTORE_PASSWORD, PROP_SSL_KEYSTORE_TYPE, PROP_CONNECTION_TIMEOUT, PROP_SOCKET_TIMEOUT, PROP_RETRY_INITIAL_DELAY, PROP_RETRY_MAX_DELAY, PROP_WAIT_ENABLED, PROP_WAIT_TIMEOUT, PROP_WAIT_RETRY_ENABLED, PROP_WAIT_RETRY_DELAY, PROP_CLUSTER_ENABLED});
    }

    protected void init(Configuration config) {
        this.address = config.getString(PROP_ADDRESS);
        this.dbIndex = config.getInteger(PROP_DB_INDEX);
        this.user = config.getString(PROP_USER);
        this.password = config.getString(PROP_PASSWORD);
        this.sslEnabled = config.getBoolean(PROP_SSL_ENABLED);
        this.hostnameVerificationEnabled = config.getBoolean(PROP_SSL_HOSTNAME_VERIFICATION_ENABLED);
        this.truststorePath = config.getString(PROP_SSL_TRUSTSTORE_PATH);
        this.truststorePassword = config.getString(PROP_SSL_TRUSTSTORE_PASSWORD);
        this.truststoreType = config.getString(PROP_SSL_TRUSTSTORE_TYPE);
        this.keystorePath = config.getString(PROP_SSL_KEYSTORE_PATH);
        this.keystorePassword = config.getString(PROP_SSL_KEYSTORE_PASSWORD);
        this.keystoreType = config.getString(PROP_SSL_KEYSTORE_TYPE);
        this.initialRetryDelay = config.getInteger(PROP_RETRY_INITIAL_DELAY);
        this.maxRetryDelay = config.getInteger(PROP_RETRY_MAX_DELAY);
        this.maxRetryCount = config.getInteger(PROP_MAX_RETRIES);
        this.connectionTimeout = config.getInteger(PROP_CONNECTION_TIMEOUT);
        this.socketTimeout = config.getInteger(PROP_SOCKET_TIMEOUT);
        this.waitEnabled = config.getBoolean(PROP_WAIT_ENABLED);
        this.waitTimeout = config.getLong(PROP_WAIT_TIMEOUT);
        this.waitRetryEnabled = config.getBoolean(PROP_WAIT_RETRY_ENABLED);
        this.waitRetryDelay = config.getLong(PROP_WAIT_RETRY_DELAY);
        this.clusterEnabled = config.getBoolean(PROP_CLUSTER_ENABLED);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAddress() {
        return this.address;
    }

    public int getDbIndex() {
        return this.dbIndex;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public boolean isHostnameVerificationEnabled() {
        return this.hostnameVerificationEnabled;
    }

    public Integer getInitialRetryDelay() {
        return this.initialRetryDelay;
    }

    public Integer getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    public Integer getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public boolean isWaitEnabled() {
        return this.waitEnabled;
    }

    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    public boolean isWaitRetryEnabled() {
        return this.waitRetryEnabled;
    }

    public long getWaitRetryDelay() {
        return this.waitRetryDelay;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public boolean isClusterEnabled() {
        return this.clusterEnabled;
    }
}

