/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.redis;

import io.debezium.DebeziumException;
import io.debezium.storage.redis.RedisClient;
import io.debezium.storage.redis.RedisClientConnectionException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;

public class JedisClient
implements RedisClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(JedisClient.class);
    private final Jedis jedis;

    public JedisClient(Jedis jedis) {
        this.jedis = jedis;
    }

    @Override
    public void disconnect() {
        this.tryErrors(() -> this.jedis.disconnect());
    }

    @Override
    public void close() {
        this.tryErrors(() -> this.jedis.close());
    }

    @Override
    public String xadd(String key, Map<String, String> hash) {
        return this.tryErrors(() -> this.jedis.xadd(key, (StreamEntryID)null, hash).toString());
    }

    @Override
    public List<String> xadd(List<AbstractMap.SimpleEntry<String, Map<String, String>>> hashes) {
        return this.tryErrors(() -> {
            try {
                this.jedis.ping();
                Pipeline pipeline = this.jedis.pipelined();
                hashes.forEach(hash -> pipeline.xadd((String)hash.getKey(), StreamEntryID.NEW_ENTRY, (Map)hash.getValue()));
                return pipeline.syncAndReturnAll().stream().map(response -> response.toString()).collect(Collectors.toList());
            }
            catch (JedisDataException jde) {
                if (!jde.getMessage().equals("LOADING Redis is loading the dataset in memory")) {
                    LOGGER.error("Unexpected JedisDataException", (Throwable)jde);
                    throw new DebeziumException((Throwable)jde);
                }
                LOGGER.error("Redis is starting", (Throwable)jde);
                return Collections.emptyList();
            }
        });
    }

    @Override
    public List<Map<String, String>> xrange(String key) {
        return this.tryErrors(() -> this.jedis.xrange(key, (StreamEntryID)null, (StreamEntryID)null).stream().map(item -> item.getFields()).collect(Collectors.toList()));
    }

    @Override
    public long xlen(String key) {
        return this.tryErrors(() -> this.jedis.xlen(key));
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        return this.tryErrors(() -> this.jedis.hgetAll(key));
    }

    @Override
    public long hset(byte[] key, byte[] field, byte[] value) {
        return this.tryErrors(() -> this.jedis.hset(key, field, value));
    }

    @Override
    public long waitReplicas(int replicas, long timeout) {
        return this.tryErrors(() -> this.jedis.waitReplicas(replicas, timeout));
    }

    public String toString() {
        return "JedisClient [jedis=" + String.valueOf(this.jedis) + "]";
    }

    private void tryErrors(Runnable runnable) {
        this.tryErrors(() -> {
            runnable.run();
            return null;
        });
    }

    private <R> R tryErrors(Supplier<R> supplier) {
        try {
            return supplier.get();
        }
        catch (JedisConnectionException e) {
            throw new RedisClientConnectionException(e);
        }
    }

    @Override
    public String info(String section) {
        return this.tryErrors(() -> this.jedis.info(section));
    }

    @Override
    public String clientList() {
        return this.tryErrors(() -> this.jedis.clientList());
    }
}

