/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.redis.offset;

import io.debezium.config.Configuration;
import io.debezium.storage.redis.RedisClient;
import io.debezium.storage.redis.RedisClientConnectionException;
import io.debezium.storage.redis.RedisConnection;
import io.debezium.storage.redis.offset.RedisOffsetBackingStoreConfig;
import io.smallrye.mutiny.Uni;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.storage.MemoryOffsetBackingStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisOffsetBackingStore
extends MemoryOffsetBackingStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisOffsetBackingStore.class);
    private RedisOffsetBackingStoreConfig config;
    private RedisClient client;

    public RedisClient getRedisClient() {
        return this.client;
    }

    public void setRedisClient(RedisClient client) {
        this.client = client;
    }

    void connect() {
        this.closeClient();
        RedisConnection redisConnection = new RedisConnection(this.config.getAddress(), this.config.getDbIndex(), this.config.getUser(), this.config.getPassword(), this.config.getConnectionTimeout(), this.config.getSocketTimeout(), this.config.isSslEnabled());
        this.client = redisConnection.getRedisClient("debezium:offsets", this.config.isWaitEnabled(), this.config.getWaitTimeout(), this.config.isWaitRetryEnabled(), this.config.getWaitRetryDelay());
    }

    public void configure(WorkerConfig config) {
        super.configure(config);
        Configuration configuration = Configuration.from((Map)config.originalsStrings());
        this.config = new RedisOffsetBackingStoreConfig(configuration);
    }

    public void configure(RedisOffsetBackingStoreConfig config) {
        this.config = config;
    }

    public synchronized void start() {
        super.start();
        LOGGER.info("Starting RedisOffsetBackingStore");
        this.connect();
        this.load();
    }

    synchronized void startNoLoad() {
        super.start();
        this.connect();
    }

    private void closeClient() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public synchronized void stop() {
        this.closeClient();
        super.stop();
        LOGGER.info("Stopped RedisOffsetBackingStore");
    }

    void load() {
        Map offsets = (Map)Uni.createFrom().item(() -> this.client.hgetAll(this.config.getRedisKeyName())).onFailure().invoke(f -> {
            LOGGER.warn("Reading from Redis offset store failed with " + f);
            LOGGER.warn("Will retry");
        }).onFailure(RedisClientConnectionException.class).invoke(f -> {
            LOGGER.warn("Attempting to reconnect to Redis");
            this.connect();
        }).onFailure().retry().withBackOff(Duration.ofMillis(this.config.getInitialRetryDelay().intValue()), Duration.ofMillis(this.config.getMaxRetryDelay().intValue())).indefinitely().invoke(item -> LOGGER.trace("Offsets fetched from Redis: " + item)).await().indefinitely();
        this.data = new HashMap();
        LOGGER.info("Offsets: {}", (Object)offsets.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(", ", "{ ", " }")));
        for (Map.Entry mapEntry : offsets.entrySet()) {
            ByteBuffer key = mapEntry.getKey() != null ? ByteBuffer.wrap(((String)mapEntry.getKey()).getBytes()) : null;
            ByteBuffer value = mapEntry.getValue() != null ? ByteBuffer.wrap(((String)mapEntry.getValue()).getBytes()) : null;
            this.data.put(key, value);
        }
    }

    protected void save() {
        for (Map.Entry mapEntry : this.data.entrySet()) {
            byte[] key = mapEntry.getKey() != null ? ((ByteBuffer)mapEntry.getKey()).array() : null;
            byte[] value = mapEntry.getValue() != null ? ((ByteBuffer)mapEntry.getValue()).array() : null;
            Uni.createFrom().item(() -> this.client.hset(this.config.getRedisKeyName().getBytes(), key, value)).onFailure().invoke(f -> {
                LOGGER.warn("Writing to Redis offset store failed with " + f);
                LOGGER.warn("Will retry");
            }).onFailure(RedisClientConnectionException.class).invoke(f -> {
                LOGGER.warn("Attempting to reconnect to Redis");
                this.connect();
            }).onFailure().retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(2L)).indefinitely().invoke(item -> LOGGER.trace("Offsets written to Redis: " + value)).await().indefinitely();
        }
    }

    public Set<Map<String, Object>> connectorPartitions(String connectorName) {
        return null;
    }
}

