/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.jdbc;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.util.Collect;
import java.time.Duration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCommonConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcCommonConfig.class);
    public static final String CONFIGURATION_FIELD_PREFIX_STRING = "jdbc.";
    public static final String CONFIGURATION_FIELD_CONNECTION_GROUP = "jdbc.connection.";
    public static final Field PROP_JDBC_URL = Field.create((String)"jdbc.connection.url").withDescription("URL of the database which will be used to access the database storage").withValidation(new Field.Validator[]{Field::isRequired}).withDeprecatedAliases(new String[]{"jdbc.url"});
    public static final Field PROP_USER = Field.create((String)"jdbc.connection.user").withDescription("Username of the database which will be used to access the database storage").withValidation(new Field.Validator[]{Field::isRequired}).withDeprecatedAliases(new String[]{"jdbc.user"});
    public static final Field PROP_PASSWORD = Field.create((String)"jdbc.connection.password").withDescription("Password of the database which will be used to access the database storage").withValidation(new Field.Validator[]{Field::isRequired}).withDeprecatedAliases(new String[]{"jdbc.password"});
    private static final long DEFAULT_WAIT_RETRY_DELAY = 3000L;
    public static final Field PROP_WAIT_RETRY_DELAY = Field.create((String)"jdbc.connection.wait.retry.delay.ms").withDescription("Delay of retry on wait for connection failure").withDefault(3000L).withDeprecatedAliases(new String[]{"jdbc.wait.retry.delay.ms"});
    private static final int DEFAULT_MAX_RETRIES = 5;
    public static final Field PROP_MAX_RETRIES = Field.create((String)"jdbc.connection.retry.max.attempts").withDescription("Maximum number of retry attempts before giving up.").withDefault(5).withDeprecatedAliases(new String[]{"jdbc.retry.max.attempts"});
    private String jdbcUrl;
    private String user;
    private String password;
    private Duration waitRetryDelay;
    private int maxRetryCount;

    public JdbcCommonConfig(Configuration config, String prefix) {
        config = config.subset(prefix, true);
        LOGGER.info("Configuration for '{}' with prefix '{}': {}", new Object[]{this.getClass().getSimpleName(), prefix, config.withMaskedPasswords().asMap()});
        if (!config.validateAndRecord(this.getAllConfigurationFields(), error -> LOGGER.error("Validation error for property with prefix '{}': {}", (Object)prefix, error))) {
            throw new DebeziumException(String.format("Error configuring an instance of '%s' with prefix '%s'; check the logs for errors", this.getClass().getSimpleName(), prefix));
        }
        this.init(config);
    }

    protected List<Field> getAllConfigurationFields() {
        return Collect.arrayListOf((Object)PROP_JDBC_URL, (Object[])new Field[]{PROP_USER, PROP_PASSWORD, PROP_WAIT_RETRY_DELAY, PROP_MAX_RETRIES});
    }

    protected void init(Configuration config) {
        this.jdbcUrl = config.getString(PROP_JDBC_URL);
        this.user = config.getString(PROP_USER);
        this.password = config.getString(PROP_PASSWORD);
        this.waitRetryDelay = Duration.ofMillis(config.getLong(PROP_WAIT_RETRY_DELAY));
        this.maxRetryCount = config.getInteger(PROP_MAX_RETRIES);
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Duration getWaitRetryDelay() {
        return this.waitRetryDelay;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }
}

