/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.file.history;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.SchemaHistoryListener;
import io.debezium.storage.file.history.FileSchemaHistory;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class DelayingFileBasedSchemaHistory
extends FileSchemaHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelayingFileBasedSchemaHistory.class);
    public static final String RECOVERY_DELAY_MS_PROPERTY = "schema.history.internal.recovery.delay.ms";
    private long recoveryDelayMs = 0L;

    @Override
    public void configure(Configuration config, HistoryRecordComparator comparator, SchemaHistoryListener listener, boolean useCatalogBeforeSchema) {
        super.configure(config, comparator, listener, useCatalogBeforeSchema);
        this.recoveryDelayMs = config.getLong(RECOVERY_DELAY_MS_PROPERTY, 0L);
    }

    protected void recoverRecords(Consumer<HistoryRecord> records) {
        this.lock.write(() -> {
            for (HistoryRecord record : this.getRecords()) {
                records.accept(record);
                if (this.recoveryDelayMs <= 0L) continue;
                try {
                    LOGGER.info("Sleeping for {} ms to simulate recovery delay", (Object)this.recoveryDelayMs);
                    Thread.sleep(this.recoveryDelayMs);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted while recovering records", e);
                }
            }
        });
    }

    @Override
    public String toString() {
        return "delaying-" + super.toString();
    }
}

