/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.scripting.wasm;

import com.dylibso.chicory.experimental.aot.AotMachine;
import com.dylibso.chicory.experimental.hostmodule.annotations.HostModule;
import com.dylibso.chicory.experimental.hostmodule.annotations.WasmExport;
import com.dylibso.chicory.runtime.ByteBufferMemory;
import com.dylibso.chicory.runtime.ImportFunction;
import com.dylibso.chicory.runtime.ImportMemory;
import com.dylibso.chicory.runtime.ImportValues;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Memory;
import com.dylibso.chicory.wasm.ChicoryException;
import com.dylibso.chicory.wasm.WasmModule;
import com.dylibso.chicory.wasm.types.MemoryLimits;
import io.debezium.DebeziumException;
import io.debezium.transforms.scripting.RecordHeader;
import io.debezium.transforms.scripting.wasm.ChicoryEngine_ModuleFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

@HostModule(value="env")
public class ChicoryEngine {
    private final Instance instance;
    private final List<Object> objects = new ArrayList<Object>();

    private ChicoryEngine(boolean aot, WasmModule module, int memoryMax) {
        ImportValues imports = ImportValues.builder().addMemory(new ImportMemory[]{new ImportMemory("env", "memory", (Memory)new ByteBufferMemory(new MemoryLimits(2, memoryMax)))}).addFunction((ImportFunction[])ChicoryEngine_ModuleFactory.toHostFunctions(this)).build();
        Instance.Builder instanceBuilder = Instance.builder((WasmModule)module).withImportValues(imports);
        if (aot) {
            try {
                this.instance = instanceBuilder.withMachineFactory(AotMachine::new).build();
            }
            catch (ChicoryException ex) {
                throw new DebeziumException("Failed to compile the WASM module to Java Bytecode, please use the fallback 'wasm.chicory-interpreter' ", (Throwable)ex);
            }
        } else {
            this.instance = instanceBuilder.build();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private int malloc(int size) {
        return (int)this.instance.export("malloc").apply(new long[]{size})[0];
    }

    private void free(int ptr) {
        this.instance.export("free").apply(new long[]{ptr});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(Object proxyObject) {
        try {
            int rootObjPtr = this.registerProxyObject(proxyObject);
            int resultPtr = (int)this.instance.export("process").apply(new long[]{rootObjPtr})[0];
            Object object = this.objects.get(resultPtr);
            return object;
        }
        finally {
            this.objects.clear();
        }
    }

    private int registerProxyObject(Object proxyObjext) {
        int index = this.objects.size();
        this.objects.add(proxyObjext);
        return index;
    }

    private Object resolveField(Object proxyObject, String fieldName) {
        if (proxyObject instanceof Map) {
            return ((Map)proxyObject).get(fieldName);
        }
        if (proxyObject instanceof Struct) {
            return ((Struct)proxyObject).get(fieldName);
        }
        if (proxyObject instanceof Schema) {
            return ((Schema)proxyObject).field(fieldName).schema();
        }
        if (proxyObject instanceof RecordHeader) {
            return ((RecordHeader)proxyObject).value;
        }
        throw new DebeziumException("Attempting to access a field: " + fieldName + " but we found unhandled type: " + proxyObject.getClass().getSimpleName());
    }

    @WasmExport
    public int get(int proxyObjectRef, int fieldNamePtr) {
        String fieldName = this.instance.memory().readCString(fieldNamePtr);
        this.free(fieldNamePtr);
        String[] split = fieldName.split("\\.");
        if (split.length == 0) {
            throw new DebeziumException("Guest module performed a Get on an empty path");
        }
        Object proxyObject = this.objects.get(proxyObjectRef);
        for (int i = 0; i < split.length; ++i) {
            proxyObject = this.resolveField(proxyObject, split[i]);
            if (i != split.length - 1) continue;
            return this.registerProxyObject(proxyObject);
        }
        throw new DebeziumException("Failed to resolve guest module Get on path: " + fieldName);
    }

    @WasmExport
    public int getString(int proxyObjectRef) {
        Object proxyObject = this.objects.get(proxyObjectRef);
        if (proxyObject.getClass().isAssignableFrom(String.class)) {
            String result = (String)proxyObject;
            int resultPtr = this.malloc(result.length() + 1);
            this.instance.memory().writeCString(resultPtr, result);
            return resultPtr;
        }
        throw new DebeziumException("Attempting to materialize a String but " + proxyObject.getClass().getSimpleName() + " found");
    }

    @WasmExport
    public int getInt(int proxyObjectRef) {
        Object proxyObject = this.objects.get(proxyObjectRef);
        if (proxyObject.getClass().isAssignableFrom(Integer.class)) {
            return (Integer)proxyObject;
        }
        if (proxyObject.getClass().isAssignableFrom(Byte.class)) {
            return ((Byte)proxyObject).intValue();
        }
        throw new DebeziumException("Attempting to materialize a Int but " + proxyObject.getClass().getSimpleName() + " found");
    }

    @WasmExport
    public int isNull(int proxyObjectRef) {
        if (this.objects.get(proxyObjectRef) == null) {
            return 1;
        }
        return 0;
    }

    @WasmExport
    public int setBool(int boolRef) {
        Boolean result = this.instance.memory().read(boolRef) == 1 ? Boolean.TRUE : Boolean.FALSE;
        this.free(boolRef);
        return this.registerProxyObject(result);
    }

    @WasmExport
    public int setInt(int intRef) {
        Integer result = this.instance.memory().readInt(intRef);
        this.free(intRef);
        return this.registerProxyObject(result);
    }

    @WasmExport
    public int setString(int stringRef) {
        String result = this.instance.memory().readCString(stringRef);
        this.free(stringRef);
        return this.registerProxyObject(result);
    }

    @WasmExport
    public int setNull() {
        return this.registerProxyObject(null);
    }

    public static class Builder {
        private boolean aot = true;
        private WasmModule module;
        private int memoryMaxLimit = -1;

        private Builder() {
        }

        public Builder withWasmModule(WasmModule module) {
            this.module = module;
            return this;
        }

        public Builder withMaxMemory(int memoryMax) {
            this.memoryMaxLimit = memoryMax;
            return this;
        }

        public Builder withAot(boolean aot) {
            this.aot = aot;
            return this;
        }

        public ChicoryEngine build() {
            Objects.requireNonNull(this.module);
            if (this.memoryMaxLimit > 65536) {
                throw new DebeziumException("Memory max limit cannot exceed: 65536 but found: " + this.memoryMaxLimit);
            }
            if (this.memoryMaxLimit == -1) {
                this.memoryMaxLimit = 65536;
            }
            return new ChicoryEngine(this.aot, this.module, this.memoryMaxLimit);
        }
    }
}

