/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.common.annotation.Incubating;
import io.debezium.config.Field;
import io.debezium.transforms.ScriptingTransformation;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;

@Incubating
public class Filter<R extends ConnectRecord<R>>
extends ScriptingTransformation<R> {
    public static final Field EXPRESSION = Field.create((String)"condition").withDisplayName("Filtering condition").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).required().withDescription("An expression determining whether the record should be filtered out. When evaluated to true the record is removed.");

    @Override
    protected R doApply(R record) {
        return (R)(this.engine.eval((ConnectRecord<?>)record, Boolean.class) != false ? record : null);
    }

    @Override
    protected Field expressionField() {
        return EXPRESSION;
    }
}

