/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schemagenerator.schema;

import io.debezium.schemagenerator.schema.Schema;
import io.debezium.schemagenerator.schema.SchemaDescriptor;
import io.debezium.schemagenerator.schema.SchemaName;
import io.debezium.util.IoUtil;
import io.smallrye.openapi.api.models.ComponentsImpl;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.info.InfoImpl;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.info.Info;

@SchemaName(value="openapi")
public class OpenApiSchema
implements Schema {
    private static final SchemaDescriptor DESCRIPTOR = new SchemaDescriptor(){

        @Override
        public String getId() {
            return "openapi";
        }

        @Override
        public String getName() {
            return "OpenAPI";
        }

        @Override
        public String getVersion() {
            return "3.0.3";
        }

        @Override
        public String getDescription() {
            return "TBD";
        }
    };
    private Format format = Format.JSON;

    @Override
    public SchemaDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public void configure(Map<String, Object> config) {
        if (null == config || config.isEmpty()) {
            return;
        }
        config.forEach((property, value) -> {
            switch (property) {
                case "format": {
                    this.format = Format.valueOf((String)((String)value));
                    break;
                }
            }
        });
    }

    @Override
    public String getSpec(org.eclipse.microprofile.openapi.models.media.Schema connectorSchema) {
        OpenAPIImpl debeziumAPI = new OpenAPIImpl();
        debeziumAPI.setOpenapi("3.0.3");
        ComponentsImpl debeziumConnectorTypeComponents = new ComponentsImpl();
        debeziumAPI.setInfo((Info)new InfoImpl());
        debeziumAPI.getInfo().setTitle("Generated by Debezium OpenAPI Generator");
        debeziumAPI.getInfo().setVersion(IoUtil.loadProperties(OpenApiSchema.class, (String)"io/debezium/schemagenerator/build.properties").getProperty("version"));
        debeziumConnectorTypeComponents.addSchema("debezium-" + String.valueOf(connectorSchema.getExtensions().get("connector-id")) + "-" + String.valueOf(connectorSchema.getExtensions().get("version")), connectorSchema);
        debeziumAPI.setComponents((Components)debeziumConnectorTypeComponents);
        try {
            return OpenApiSerializer.serialize((OpenAPI)debeziumAPI, (Format)this.format);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

