/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schemagenerator;

import io.debezium.metadata.ConnectorMetadata;
import io.debezium.metadata.ConnectorMetadataProvider;
import io.debezium.schemagenerator.JsonSchemaCreatorService;
import io.debezium.schemagenerator.schema.Schema;
import io.debezium.schemagenerator.schema.SchemaName;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public class SchemaGenerator {
    private static final System.Logger LOGGER = System.getLogger(SchemaGenerator.class.getName());

    public static void main(String[] args) {
        if (args.length != 5) {
            LOGGER.log(System.Logger.Level.INFO, "There were " + args.length + " arguments:");
            for (int i = 0; i < args.length; ++i) {
                LOGGER.log(System.Logger.Level.INFO, "  Argument #[" + i + "]: " + args[i]);
            }
            throw new IllegalArgumentException("Usage: SchemaGenerator <format-name> <output-directory> <groupDirectoryPerConnector> <filenamePrefix> <filenameSuffix>");
        }
        String formatName = args[0].trim();
        Path outputDirectory = new File(args[1]).toPath();
        boolean groupDirectoryPerConnector = Boolean.parseBoolean(args[2]);
        String filenamePrefix = args[3];
        String filenameSuffix = args[4];
        new SchemaGenerator().run(formatName, outputDirectory, groupDirectoryPerConnector, filenamePrefix, filenameSuffix);
    }

    private void run(String formatName, Path outputDirectory, boolean groupDirectoryPerConnector, String filenamePrefix, String filenameSuffix) {
        List<ConnectorMetadata> allMetadata = this.getMetadata();
        Schema format = this.getSchemaFormat(formatName);
        LOGGER.log(System.Logger.Level.INFO, "Using schema format: " + format.getDescriptor().getName());
        if (allMetadata.isEmpty()) {
            throw new RuntimeException("No connectors found in classpath. Exiting!");
        }
        for (ConnectorMetadata connectorMetadata : allMetadata) {
            LOGGER.log(System.Logger.Level.INFO, "Creating \"" + format.getDescriptor().getName() + "\" schema for connector: " + connectorMetadata.getConnectorDescriptor().getName() + "...");
            JsonSchemaCreatorService jsonSchemaCreatorService = new JsonSchemaCreatorService(connectorMetadata, format.getFieldFilter());
            org.eclipse.microprofile.openapi.models.media.Schema buildConnectorSchema = jsonSchemaCreatorService.buildConnectorSchema();
            String spec = format.getSpec(buildConnectorSchema);
            try {
                Object schemaFilename = "";
                if (groupDirectoryPerConnector) {
                    schemaFilename = (String)schemaFilename + connectorMetadata.getConnectorDescriptor().getId() + File.separator;
                }
                if (null != filenamePrefix && !filenamePrefix.isEmpty()) {
                    schemaFilename = (String)schemaFilename + filenamePrefix;
                }
                schemaFilename = (String)schemaFilename + connectorMetadata.getConnectorDescriptor().getId();
                if (null != filenameSuffix && !filenameSuffix.isEmpty()) {
                    schemaFilename = (String)schemaFilename + filenameSuffix;
                }
                schemaFilename = (String)schemaFilename + ".json";
                Path schemaFilePath = outputDirectory.resolve((String)schemaFilename);
                schemaFilePath.getParent().toFile().mkdirs();
                Files.write(schemaFilePath, spec.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't write file", e);
            }
        }
    }

    private List<ConnectorMetadata> getMetadata() {
        ServiceLoader<ConnectorMetadataProvider> metadataProviders = ServiceLoader.load(ConnectorMetadataProvider.class);
        return metadataProviders.stream().map(p -> ((ConnectorMetadataProvider)p.get()).getConnectorMetadata()).collect(Collectors.toList());
    }

    private Schema getSchemaFormat(String formatName) {
        ServiceLoader<Schema> schemaFormats = ServiceLoader.load(Schema.class);
        if (0L == schemaFormats.stream().count()) {
            throw new RuntimeException("No schema formats found!");
        }
        LOGGER.log(System.Logger.Level.INFO, "Registered schemas: " + schemaFormats.stream().map(schemaFormat -> ((Schema)schemaFormat.get()).getDescriptor().getId()).collect(Collectors.joining(", ")));
        Optional<ServiceLoader.Provider> format = schemaFormats.stream().filter(p -> p.type().getAnnotation(SchemaName.class).value().equals(formatName)).findFirst();
        return (Schema)format.orElseThrow().get();
    }
}

