/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage.dataset;

import io.debezium.openlineage.DebeziumOpenLineageConfiguration;
import io.debezium.openlineage.dataset.DatasetNamespaceResolver;
import java.util.Map;
import java.util.function.Function;

public class KafkaDatasetNamespaceResolver
implements DatasetNamespaceResolver {
    private static final String LIST_SEPARATOR = ",";
    private static final String KAFKA_NAMESPACE_FORMAT = "kafka://%s";
    private static final String SCHEMA_HISTORY_INTERNAL_KAFKA_BOOTSTRAP_SERVERS_PROPERTY = "schema.history.internal.kafka.bootstrap.servers";

    @Override
    public String resolve(Map<String, String> configuration, String connectorName) {
        String autoDetectedKafkaAddress = DebeziumOpenLineageConfiguration.getList(configuration, SCHEMA_HISTORY_INTERNAL_KAFKA_BOOTSTRAP_SERVERS_PROPERTY, LIST_SEPARATOR, Function.identity()).stream().findFirst().orElse("unknown:unknown");
        String kafkaAddress = configuration.getOrDefault("openlineage.integration.dataset.kafka.bootstrap.servers", autoDetectedKafkaAddress);
        return String.format(KAFKA_NAMESPACE_FORMAT, kafkaAddress);
    }
}

