/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage.dataset;

import io.debezium.openlineage.dataset.DatasetNamespaceResolver;
import io.debezium.openlineage.dataset.DefaultDatabaseNamespaceResolver;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JdbcDatasetNamespaceResolver
implements DatasetNamespaceResolver {
    private static final String CONNECTION_URL = "connection.url";
    private static final Pattern JDBC_PATTERN = Pattern.compile("^jdbc:([^:]+)(?::thin:@(?://)?|://)([^:/]+)(?::(\\d+))?");
    private static final Map<String, String> DEFAULT_PORTS = Map.of("mysql", "3306", "mariadb", "3306", "postgresql", "5432", "oracle", "1521", "sqlserver", "1433", "mongodb", "27017", "db2", "50000");

    @Override
    public String resolve(Map<String, String> configuration, String connectorName) {
        String port;
        String connectionUrl = configuration.get(CONNECTION_URL);
        if (connectionUrl == null) {
            return "unknown:unknown";
        }
        Matcher matcher = JDBC_PATTERN.matcher(connectionUrl);
        if (!matcher.find()) {
            return "unknown:unknown";
        }
        String database = matcher.group(1);
        String hostname = matcher.group(2);
        String string = port = matcher.group(3) != null ? matcher.group(3) : DEFAULT_PORTS.getOrDefault(database.toLowerCase(), "");
        if ("postgresql".equalsIgnoreCase(database)) {
            database = "postgres";
        }
        return String.format(DefaultDatabaseNamespaceResolver.INPUT_DATASET_NAMESPACE_FORMAT, database, hostname, port);
    }
}

