/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage.dataset;

import io.debezium.openlineage.dataset.DatasetNamespaceResolverFactory;
import io.debezium.openlineage.dataset.DefaultInputDatasetNamespaceResolver;
import io.debezium.openlineage.dataset.DefaultOutputDatasetNamespaceResolver;
import io.debezium.openlineage.dataset.InputDatasetNamespaceResolver;
import io.debezium.openlineage.dataset.MongoDbDatasetNamespaceResolver;
import io.debezium.openlineage.dataset.OutputDatasetNamespaceResolver;
import io.debezium.openlineage.dataset.PostgresDatasetNamespaceResolver;

public class DefaultDatasetNamespaceResolverFactory
implements DatasetNamespaceResolverFactory {
    private static final String MONGODB = "mongodb";
    private static final String POSTGRESQL = "postgresql";

    @Override
    public InputDatasetNamespaceResolver createInput(String connectorName) {
        return switch (connectorName) {
            case MONGODB -> new MongoDbDatasetNamespaceResolver();
            case POSTGRESQL -> new PostgresDatasetNamespaceResolver();
            default -> new DefaultInputDatasetNamespaceResolver();
        };
    }

    @Override
    public OutputDatasetNamespaceResolver createOutput(String connectorName) {
        return new DefaultOutputDatasetNamespaceResolver();
    }
}

