/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public record DebeziumOpenLineageConfiguration(boolean enabled, Config config, Job job) {
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final String LIST_SEPARATOR = ",";

    public static DebeziumOpenLineageConfiguration from(Map<String, String> configuration) {
        Map<String, String> tags = DebeziumOpenLineageConfiguration.getList(configuration, "openlineage.integration.job.tags", LIST_SEPARATOR, pair -> pair.split(KEY_VALUE_SEPARATOR)).stream().collect(Collectors.toMap(pair -> pair[0].trim(), pair -> pair[1].trim()));
        Map<String, String> owners = DebeziumOpenLineageConfiguration.getList(configuration, "openlineage.integration.job.owners", LIST_SEPARATOR, pair -> pair.split(KEY_VALUE_SEPARATOR)).stream().collect(Collectors.toMap(pair -> pair[0].trim(), pair -> pair[1].trim()));
        return new DebeziumOpenLineageConfiguration(Boolean.parseBoolean(configuration.get("openlineage.integration.enabled")), new Config(configuration.get("openlineage.integration.config.file.path")), new Job(configuration.getOrDefault("openlineage.integration.job.namespace", configuration.get("topic.prefix")), configuration.get("openlineage.integration.job.description"), tags, owners));
    }

    public static <T> List<T> getList(Map<String, String> configuration, String key, String separator, Function<String, T> converter) {
        String value = configuration.get(key);
        return value == null ? List.of() : Arrays.stream(value.split(Pattern.quote(separator))).map(String::trim).map(converter).toList();
    }

    public record Config(String path) {
    }

    public record Job(String namespace, String description, Map<String, String> tags, Map<String, String> owners) {
    }
}

