/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage;

import io.debezium.openlineage.ConnectorContext;
import io.debezium.openlineage.DebeziumOpenLineageConfiguration;
import io.debezium.openlineage.OpenLineageContext;
import io.debezium.openlineage.OpenLineageJobIdentifier;
import io.debezium.openlineage.dataset.DatasetNamespaceResolverFactory;
import io.debezium.openlineage.dataset.DefaultDatasetNamespaceResolverFactory;
import io.debezium.openlineage.emitter.DebeziumOpenLineageClient;
import io.debezium.openlineage.emitter.LineageEmitter;
import io.debezium.openlineage.emitter.LineageEmitterFactory;
import io.debezium.openlineage.emitter.NoOpLineageEmitter;
import io.debezium.openlineage.emitter.OpenLineageEmitter;
import io.openlineage.client.OpenLineage;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumLineageEmitterFactory
implements LineageEmitterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebeziumLineageEmitterFactory.class);
    private static final ServiceLoader<DatasetNamespaceResolverFactory> datasetNamespaceResolverFactory = ServiceLoader.load(DatasetNamespaceResolverFactory.class);
    private final AtomicReference<OpenLineageContext> contextRef = new AtomicReference();

    public LineageEmitter get(ConnectorContext connectorContext) {
        DebeziumOpenLineageConfiguration debeziumOpenLineageConfiguration = DebeziumOpenLineageConfiguration.from(connectorContext.config());
        if (debeziumOpenLineageConfiguration.enabled()) {
            DebeziumOpenLineageClient emitter = new DebeziumOpenLineageClient(connectorContext, debeziumOpenLineageConfiguration);
            if (this.contextRef.get() == null) {
                LOGGER.debug("OpenLineageContext was null, getting instance");
                OpenLineageContext ctx = new OpenLineageContext(new OpenLineage(emitter.getProducer()), debeziumOpenLineageConfiguration, OpenLineageJobIdentifier.from(connectorContext.config(), debeziumOpenLineageConfiguration));
                this.contextRef.compareAndSet(null, ctx);
            }
            DatasetNamespaceResolverFactory namespaceResolverFactory = datasetNamespaceResolverFactory.stream().findFirst().map(ServiceLoader.Provider::get).orElse(new DefaultDatasetNamespaceResolverFactory());
            LOGGER.debug("OpenLineageContext {}", (Object)this.contextRef.get());
            return new OpenLineageEmitter(connectorContext, this.contextRef.get(), emitter, namespaceResolverFactory.createInput(connectorContext.connectorName()), namespaceResolverFactory.createOutput(connectorContext.connectorName()));
        }
        return new NoOpLineageEmitter();
    }
}

