/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.openlineage;

import io.debezium.openlineage.DebeziumOpenLineageConfiguration;
import io.debezium.openlineage.OpenLineageJobIdentifier;
import io.openlineage.client.OpenLineage;
import io.openlineage.client.utils.UUIDUtils;
import java.util.Objects;
import java.util.UUID;

public class OpenLineageContext {
    private final UUID runUuid;
    private final OpenLineage openLineage;
    private final DebeziumOpenLineageConfiguration configuration;
    private final OpenLineageJobIdentifier jobIdentifier;

    public OpenLineageContext(OpenLineage openLineage, DebeziumOpenLineageConfiguration configuration, OpenLineageJobIdentifier jobIdentifier) {
        this.openLineage = openLineage;
        this.configuration = configuration;
        this.jobIdentifier = jobIdentifier;
        this.runUuid = UUIDUtils.generateNewUUID();
    }

    public OpenLineage getOpenLineage() {
        return this.openLineage;
    }

    public DebeziumOpenLineageConfiguration getConfiguration() {
        return this.configuration;
    }

    public UUID getRunUuid() {
        return this.runUuid;
    }

    public OpenLineageJobIdentifier getJobIdentifier() {
        return this.jobIdentifier;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenLineageContext that = (OpenLineageContext)o;
        return Objects.equals(this.runUuid, that.runUuid);
    }

    public int hashCode() {
        return Objects.hashCode(this.runUuid);
    }

    public String toString() {
        return "OpenLineageContext{runUuid=" + String.valueOf(this.runUuid) + ", openLineage=" + String.valueOf(this.openLineage) + ", configuration=" + String.valueOf(this.configuration) + ", jobIdentifier=" + String.valueOf(this.jobIdentifier) + "}";
    }
}

