/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.performance.connector.postgres;

import io.debezium.connector.postgresql.PostgresStreamingChangeEventSource;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.connection.AbstractReplicationMessageColumn;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
public class PostgresTypeMetadataPerf {
    private static final int OP_COUNT = 10;
    private static final int MOD_COUNT = 10;
    private static final String[] MODIFIERS = new String[]{"text", "character varying(255)", "numeric(12,3)", "geometry(MultiPolygon,4326)", "timestamp (12) with time zone", "int[]", "myschema.geometry", "float[10]", "date", "bytea"};
    private ReplicationMessage.Column[] columns = new ReplicationMessage.Column[10];

    private ReplicationMessage.Column createColumn(int modifierIndex) {
        String columnName = "test";
        PostgresType columnType = PostgresType.UNKNOWN;
        String typeWithModifiers = MODIFIERS[modifierIndex];
        boolean optional = true;
        return new AbstractReplicationMessageColumn(columnName, columnType, typeWithModifiers, optional){

            public Object getValue(PostgresStreamingChangeEventSource.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
                return null;
            }
        };
    }

    @Setup(value=Level.Invocation)
    public void setup() {
        Random random = new Random(1234L);
        for (int i = 0; i < 10; ++i) {
            this.columns[i] = this.createColumn(random.nextInt(10));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    @Fork(value=1)
    @OperationsPerInvocation(value=10)
    public void columnMetadata(Blackhole bh) {
        for (int i = 0; i < 10; ++i) {
            bh.consume((Object)this.columns[i].getTypeMetadata());
        }
    }
}

